/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.internal;

import com.google.common.base.Predicate;
import org.gradle.api.Project;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.platform.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTestSuiteBinariesRules
extends RuleSource {
    public static <T extends NativeTestSuiteBinarySpec> void apply(ModelRegistry registry, Class<T> testSuiteBinaryClass) {
        registry.getRoot().applyTo(NodePredicate.allDescendants((Predicate)ModelNodes.withType(testSuiteBinaryClass)), NativeTestSuiteBinariesRules.class);
    }

    @Mutate
    public void configureRunTask(NativeTestSuiteBinarySpecInternal testSuiteBinary) {
        BinaryNamingScheme namingScheme = testSuiteBinary.getNamingScheme();
        NativeTestSuiteBinarySpec.TasksCollection tasks = testSuiteBinary.getTasks();
        InstallExecutable installTask = (InstallExecutable)tasks.getInstall();
        RunTestExecutable runTask = (RunTestExecutable)tasks.getRun();
        runTask.getInputs().files(new Object[]{installTask.getOutputs().getFiles()});
        runTask.setExecutable(installTask.getRunScript().getPath());
        Project project = runTask.getProject();
        runTask.setOutputDir(namingScheme.getOutputDirectory(project.getBuildDir(), "test-results"));
    }
}

