/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.plugins.NativeComponentPlugin;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.DefaultNativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.testing.base.plugins.TestingModelBasePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeBinariesTestPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentPlugin.class);
        project.getPluginManager().apply(TestingModelBasePlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @BinaryType
        void nativeTestSuiteBinary(BinaryTypeBuilder<NativeTestSuiteBinarySpec> builder) {
            builder.defaultImplementation(DefaultNativeTestSuiteBinarySpec.class);
            builder.internalView(NativeTestSuiteBinarySpecInternal.class);
        }

        @Defaults
        void attachTestedBinarySourcesToTestBinaries(ModelMap<NativeTestSuiteBinarySpecInternal> binaries) {
            binaries.afterEach((Action)new Action<NativeTestSuiteBinarySpecInternal>(){

                public void execute(NativeTestSuiteBinarySpecInternal testSuiteBinary) {
                    NativeBinarySpec testedBinary = testSuiteBinary.getTestedBinary();
                    for (DependentSourceSet testSource : testSuiteBinary.getInputs().withType(DependentSourceSet.class)) {
                        testSource.lib((Object)testedBinary.getInputs());
                    }
                    testSuiteBinary.getInputs().addAll((Collection)testedBinary.getInputs());
                }
            });
        }
    }
}

