/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.gradle.model.internal.manage.binding.ManagedProperty;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInitializerContext<T> {
    private final ModelType<T> modelType;
    private final ModelType<? super T> baseType;
    private final Optional<PropertyContext> propertyContextOptional;

    public NodeInitializerContext(ModelType<T> modelType, ModelType<? super T> baseType, Optional<PropertyContext> propertyContextOptional) {
        this.modelType = modelType;
        this.baseType = baseType;
        this.propertyContextOptional = propertyContextOptional;
    }

    public static <T> NodeInitializerContext<T> forType(ModelType<T> type) {
        return new NodeInitializerContext<Object>(type, ModelType.UNTYPED, (Optional<PropertyContext>)Optional.absent());
    }

    public static <T> NodeInitializerContext<T> forExtensibleType(ModelType<T> type, ModelType<? super T> baseType) {
        return new NodeInitializerContext<T>(type, baseType, (Optional<PropertyContext>)Optional.absent());
    }

    public static <T> NodeInitializerContext<T> forProperty(ModelType<T> type, ManagedProperty<?> property, ModelType<?> containingType) {
        return new NodeInitializerContext<Object>(type, ModelType.UNTYPED, (Optional<PropertyContext>)Optional.of((Object)new PropertyContext(property.getName(), property.getType(), property.isWritable(), property.isDeclaredAsHavingUnmanagedType(), containingType)));
    }

    public ModelType<T> getModelType() {
        return this.modelType;
    }

    public ModelType<? super T> getBaseType() {
        return this.baseType;
    }

    public Optional<PropertyContext> getPropertyContextOptional() {
        return this.propertyContextOptional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInitializerContext that = (NodeInitializerContext)o;
        return Objects.equal(this.modelType, that.modelType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modelType});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyContext {
        private final String name;
        private final ModelType<?> type;
        private final boolean writable;
        private final boolean declaredAsHavingUnmanagedType;
        private final ModelType<?> declaringType;

        private PropertyContext(String name, ModelType<?> type, boolean writable, boolean declaredAsHavingUnmanagedType, ModelType<?> declaringType) {
            this.name = name;
            this.type = type;
            this.writable = writable;
            this.declaredAsHavingUnmanagedType = declaredAsHavingUnmanagedType;
            this.declaringType = declaringType;
        }

        public String getName() {
            return this.name;
        }

        public ModelType<?> getType() {
            return this.type;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public boolean isDeclaredAsHavingUnmanagedType() {
            return this.declaredAsHavingUnmanagedType;
        }

        public ModelType<?> getDeclaringType() {
            return this.declaringType;
        }
    }
}

