/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArraySerializer
implements Serializer<Object[]> {
    private final Serializer<Object> elementSerializer;

    public ObjectArraySerializer(Serializer<Object> elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    @Override
    public void write(Encoder encoder, Object[] value) throws Exception {
        encoder.writeSmallInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.elementSerializer.write(encoder, value[i]);
        }
    }

    @Override
    public Object[] read(Decoder decoder) throws Exception {
        int len = decoder.readSmallInt();
        Object[] result = new Object[len];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.elementSerializer.read(decoder);
        }
        return result;
    }
}

