/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryResolveException;
import org.gradle.nativeplatform.platform.NativePlatform;

public abstract class AbstractPrebuiltLibraryBinary
extends AbstractBuildableModelElement
implements NativeLibraryBinary {
    private final String name;
    private final PrebuiltLibrary library;
    private final BuildType buildType;
    private final NativePlatform targetPlatform;
    private final Flavor flavor;

    public AbstractPrebuiltLibraryBinary(String name, PrebuiltLibrary library, BuildType buildType, NativePlatform targetPlatform, Flavor flavor) {
        this.name = name;
        this.library = library;
        this.buildType = buildType;
        this.targetPlatform = targetPlatform;
        this.flavor = flavor;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.name;
    }

    public PrebuiltLibrary getComponent() {
        return this.library;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public Flavor getFlavor() {
        return this.flavor;
    }

    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public FileCollection getHeaderDirs() {
        return new SimpleFileCollection((Collection)this.library.getHeaders().getSrcDirs());
    }

    protected FileCollection createFileCollection(File file, String fileDescription) {
        return new FileCollectionAdapter((MinimalFileSet)new ValidatingFileSet(file, this.getComponent().getName(), fileDescription));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidatingFileSet
    implements MinimalFileSet {
        private final File file;
        private final String libraryName;
        private final String fileDescription;

        private ValidatingFileSet(File file, String libraryName, String fileDescription) {
            this.file = file;
            this.libraryName = libraryName;
            this.fileDescription = fileDescription;
        }

        public String getDisplayName() {
            return String.format("%s for prebuilt library '%s'", this.fileDescription, this.libraryName);
        }

        public Set<File> getFiles() {
            if (this.file == null) {
                throw new PrebuiltLibraryResolveException(String.format("%s not set for prebuilt library '%s'.", this.fileDescription, this.libraryName));
            }
            if (!this.file.exists() || !this.file.isFile()) {
                throw new PrebuiltLibraryResolveException(String.format("%s %s does not exist for prebuilt library '%s'.", this.fileDescription, this.file.getAbsolutePath(), this.libraryName));
            }
            return Collections.singleton(this.file);
        }
    }
}

