/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.plugins;

import com.google.common.base.Predicate;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.BuildTypeContainer;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.FlavorContainer;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.NativeExecutableSpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.TargetedNativeComponent;
import org.gradle.nativeplatform.internal.DefaultBuildTypeContainer;
import org.gradle.nativeplatform.internal.DefaultFlavorContainer;
import org.gradle.nativeplatform.internal.DefaultNativeExecutableBinarySpec;
import org.gradle.nativeplatform.internal.DefaultNativeExecutableSpec;
import org.gradle.nativeplatform.internal.DefaultNativeLibrarySpec;
import org.gradle.nativeplatform.internal.DefaultSharedLibraryBinarySpec;
import org.gradle.nativeplatform.internal.DefaultStaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativeComponents;
import org.gradle.nativeplatform.internal.NativeExecutableBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativePlatformResolver;
import org.gradle.nativeplatform.internal.SharedLibraryBinarySpecInternal;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.nativeplatform.internal.configure.NativeComponentRules;
import org.gradle.nativeplatform.internal.pch.PchEnabledLanguageTransform;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltLibraries;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryInitializer;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatforms;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.PrefixHeaderFileGenerateTask;
import org.gradle.nativeplatform.toolchain.internal.DefaultNativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeComponentModelPlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;
    private final ModelRegistry modelRegistry;

    @Inject
    public NativeComponentModelPlugin(ModelRegistry modelRegistry, Instantiator instantiator) {
        this.modelRegistry = modelRegistry;
        this.instantiator = instantiator;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        project.getExtensions().create("buildTypes", DefaultBuildTypeContainer.class, new Object[]{this.instantiator});
        project.getExtensions().create("flavors", DefaultFlavorContainer.class, new Object[]{this.instantiator});
        project.getExtensions().create("toolChains", DefaultNativeToolChainRegistry.class, new Object[]{this.instantiator});
        this.modelRegistry.getRoot().applyTo(NodePredicate.allDescendants((Predicate)ModelNodes.withType(NativeComponentSpec.class)), NativeComponentRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactRepositoryNamer
    implements Namer<ArtifactRepository> {
        private ArtifactRepositoryNamer() {
        }

        public String determineName(ArtifactRepository object) {
            return object.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRepositories
    extends DefaultPolymorphicDomainObjectContainer<ArtifactRepository>
    implements Repositories {
        private DefaultRepositories(final Instantiator instantiator, final FileResolver fileResolver, final Action<PrebuiltLibrary> binaryFactory) {
            super(ArtifactRepository.class, instantiator, (Namer)new ArtifactRepositoryNamer());
            this.registerFactory(PrebuiltLibraries.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<PrebuiltLibraries>(){

                public PrebuiltLibraries create(String name) {
                    return (PrebuiltLibraries)instantiator.newInstance(DefaultPrebuiltLibraries.class, new Object[]{name, instantiator, fileResolver, binaryFactory});
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void nativeExecutable(ComponentTypeBuilder<NativeExecutableSpec> builder) {
            builder.defaultImplementation(DefaultNativeExecutableSpec.class);
        }

        @ComponentType
        void nativeLibrary(ComponentTypeBuilder<NativeLibrarySpec> builder) {
            builder.defaultImplementation(DefaultNativeLibrarySpec.class);
        }

        @ComponentType
        void registerTargetedNativeComponent(ComponentTypeBuilder<TargetedNativeComponent> builder) {
            builder.internalView(TargetedNativeComponentInternal.class);
        }

        @Model
        Repositories repositories(ServiceRegistry serviceRegistry, FlavorContainer flavors, PlatformContainer platforms, BuildTypeContainer buildTypes) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            NativePlatforms nativePlatforms = (NativePlatforms)serviceRegistry.get(NativePlatforms.class);
            PrebuiltLibraryInitializer initializer = new PrebuiltLibraryInitializer(instantiator, nativePlatforms, (Collection<? extends NativePlatform>)platforms.withType(NativePlatform.class), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            return new DefaultRepositories(instantiator, fileResolver, initializer);
        }

        @Model
        NativeToolChainRegistryInternal toolChains(ExtensionContainer extensionContainer) {
            return (NativeToolChainRegistryInternal)extensionContainer.getByType(NativeToolChainRegistryInternal.class);
        }

        @Model
        BuildTypeContainer buildTypes(ExtensionContainer extensionContainer) {
            return (BuildTypeContainer)extensionContainer.getByType(BuildTypeContainer.class);
        }

        @Model
        FlavorContainer flavors(ExtensionContainer extensionContainer) {
            return (FlavorContainer)extensionContainer.getByType(FlavorContainer.class);
        }

        @Mutate
        public void registerNativePlatformResolver(PlatformResolvers resolvers, ServiceRegistry serviceRegistry) {
            resolvers.register((PlatformResolver)serviceRegistry.get(NativePlatformResolver.class));
        }

        @Defaults
        public void registerFactoryForCustomNativePlatforms(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NamedDomainObjectFactory<NativePlatform> nativePlatformFactory = new NamedDomainObjectFactory<NativePlatform>(){

                public NativePlatform create(String name) {
                    return (NativePlatform)instantiator.newInstance(DefaultNativePlatform.class, new Object[]{name});
                }
            };
            platforms.registerFactory(NativePlatform.class, (NamedDomainObjectFactory)nativePlatformFactory);
            platforms.registerFactory(Platform.class, (NamedDomainObjectFactory)nativePlatformFactory);
        }

        @BinaryType
        void registerSharedLibraryBinaryType(BinaryTypeBuilder<SharedLibraryBinarySpec> builder) {
            builder.defaultImplementation(DefaultSharedLibraryBinarySpec.class);
            builder.internalView(SharedLibraryBinarySpecInternal.class);
        }

        @BinaryType
        void registerStaticLibraryBinaryType(BinaryTypeBuilder<StaticLibraryBinarySpec> builder) {
            builder.defaultImplementation(DefaultStaticLibraryBinarySpec.class);
            builder.internalView(StaticLibraryBinarySpecInternal.class);
        }

        @BinaryType
        void registerNativeExecutableBinaryType(BinaryTypeBuilder<NativeExecutableBinarySpec> builder) {
            builder.defaultImplementation(DefaultNativeExecutableBinarySpec.class);
            builder.internalView(NativeExecutableBinarySpecInternal.class);
        }

        @Finalize
        public void createDefaultToolChain(NativeToolChainRegistryInternal toolChains) {
            if (toolChains.isEmpty()) {
                toolChains.addDefaultToolChains();
            }
        }

        @Finalize
        public void createDefaultBuildTypes(BuildTypeContainer buildTypes) {
            if (buildTypes.isEmpty()) {
                buildTypes.create("debug");
            }
        }

        @Finalize
        public void createDefaultFlavor(FlavorContainer flavors) {
            if (flavors.isEmpty()) {
                flavors.create("default");
            }
        }

        @Mutate
        void configureGeneratedSourceSets(ModelMap<NativeComponentSpec> componentSpecs) {
            componentSpecs.afterEach((Action)new Action<NativeComponentSpec>(){

                public void execute(NativeComponentSpec componentSpec) {
                    componentSpec.getSources().withType(LanguageSourceSetInternal.class).afterEach((Action)new Action<LanguageSourceSetInternal>(){

                        public void execute(LanguageSourceSetInternal languageSourceSet) {
                            Task generatorTask = languageSourceSet.getGeneratorTask();
                            if (generatorTask != null) {
                                languageSourceSet.builtBy(new Object[]{generatorTask});
                                Rules.this.maybeSetSourceDir(languageSourceSet.getSource(), generatorTask, "sourceDir");
                                if (languageSourceSet instanceof HeaderExportingSourceSet) {
                                    Rules.this.maybeSetSourceDir(((HeaderExportingSourceSet)languageSourceSet).getExportedHeaders(), generatorTask, "headerDir");
                                }
                            }
                        }
                    });
                }
            });
        }

        @Mutate
        void configurePrefixHeaderFiles(ModelMap<NativeComponentSpec> componentSpecs, final @Path(value="buildDir") File buildDir) {
            componentSpecs.afterEach((Action)new Action<NativeComponentSpec>(){

                public void execute(final NativeComponentSpec componentSpec) {
                    componentSpec.getSources().withType(DependentSourceSetInternal.class).afterEach((Action)new Action<DependentSourceSetInternal>(){

                        public void execute(DependentSourceSetInternal dependentSourceSet) {
                            if (dependentSourceSet.getPreCompiledHeader() != null) {
                                String prefixHeaderDirName = String.format("tmp/%s/%s/prefixHeaders", componentSpec.getName(), dependentSourceSet.getName());
                                File prefixHeaderDir = new File(buildDir, prefixHeaderDirName);
                                File prefixHeaderFile = new File(prefixHeaderDir, "prefix-headers.h");
                                dependentSourceSet.setPrefixHeaderFile(prefixHeaderFile);
                            }
                        }
                    });
                }
            });
        }

        @Mutate
        void configurePrefixHeaderGenerationTasks(TaskContainer tasks, ModelMap<NativeComponentSpec> nativeComponents) {
            for (NativeComponentSpec nativeComponentSpec : nativeComponents.values()) {
                for (final DependentSourceSetInternal dependentSourceSet : nativeComponentSpec.getSources().withType(DependentSourceSetInternal.class).values()) {
                    if (dependentSourceSet.getPrefixHeaderFile() == null) continue;
                    String taskName = String.format("generate%s%sPrefixHeaderFile", StringUtils.capitalize((String)nativeComponentSpec.getName()), StringUtils.capitalize((String)dependentSourceSet.getName()));
                    tasks.create(taskName, PrefixHeaderFileGenerateTask.class, (Action)new Action<PrefixHeaderFileGenerateTask>(){

                        public void execute(PrefixHeaderFileGenerateTask prefixHeaderFileGenerateTask) {
                            prefixHeaderFileGenerateTask.setPrefixHeaderFile(dependentSourceSet.getPrefixHeaderFile());
                            prefixHeaderFileGenerateTask.setHeader(dependentSourceSet.getPreCompiledHeader());
                        }
                    });
                }
            }
        }

        @Mutate
        void configurePreCompiledHeaderCompileTasks(final TaskContainer tasks, ModelMap<NativeBinarySpecInternal> binaries, LanguageTransformContainer languageTransforms, final ServiceRegistry serviceRegistry) {
            for (final NativeBinarySpecInternal nativeBinarySpec : binaries.values()) {
                for (final PchEnabledLanguageTransform transform : languageTransforms.withType(PchEnabledLanguageTransform.class)) {
                    nativeBinarySpec.getInputs().withType(transform.getSourceSetType(), (Action)new Action<LanguageSourceSet>(){

                        public void execute(LanguageSourceSet languageSourceSet) {
                            final DependentSourceSet dependentSourceSet = (DependentSourceSet)languageSourceSet;
                            if (dependentSourceSet.getPreCompiledHeader() != null) {
                                nativeBinarySpec.getPrefixFileToPCH().put(((DependentSourceSetInternal)dependentSourceSet).getPrefixHeaderFile(), new PreCompiledHeader());
                                final SourceTransformTaskConfig pchTransformTaskConfig = transform.getPchTransformTask();
                                String pchTaskName = String.format("%s%s%sPreCompiledHeader", pchTransformTaskConfig.getTaskPrefix(), StringUtils.capitalize((String)nativeBinarySpec.getProjectScopedName()), StringUtils.capitalize((String)dependentSourceSet.getName()));
                                Task pchTask = tasks.create(pchTaskName, pchTransformTaskConfig.getTaskType(), (Action)new Action<DefaultTask>(){

                                    public void execute(DefaultTask task) {
                                        pchTransformTaskConfig.configureTask((Task)task, (BinarySpec)nativeBinarySpec, (LanguageSourceSet)dependentSourceSet, serviceRegistry);
                                    }
                                });
                                nativeBinarySpec.getTasks().add((Object)pchTask);
                            }
                        }
                    });
                }
            }
        }

        private void maybeSetSourceDir(SourceDirectorySet sourceSet, Task task, String propertyName) {
            Object value = task.property(propertyName);
            if (value != null) {
                sourceSet.srcDir(value);
            }
        }

        @BinaryTasks
        public void sharedLibraryTasks(ModelMap<Task> tasks, final SharedLibraryBinarySpecInternal binary) {
            String taskName = binary.getNamingScheme().getTaskName("link");
            tasks.create(taskName, LinkSharedLibrary.class, (Action)new Action<LinkSharedLibrary>(){

                public void execute(LinkSharedLibrary linkTask) {
                    linkTask.setDescription("Links " + binary.getDisplayName());
                    linkTask.setToolChain(binary.getToolChain());
                    linkTask.setTargetPlatform(binary.getTargetPlatform());
                    linkTask.setOutputFile(binary.getSharedLibraryFile());
                    linkTask.setInstallName(binary.getSharedLibraryFile().getName());
                    linkTask.setLinkerArgs(binary.getLinker().getArgs());
                    linkTask.lib(new NativeComponents.BinaryLibs(binary){

                        protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                            return nativeDependencySet.getLinkFiles();
                        }
                    });
                }
            });
        }

        @BinaryTasks
        public void staticLibraryTasks(ModelMap<Task> tasks, final StaticLibraryBinarySpecInternal binary) {
            String taskName = binary.getNamingScheme().getTaskName("create");
            tasks.create(taskName, CreateStaticLibrary.class, (Action)new Action<CreateStaticLibrary>(){

                public void execute(CreateStaticLibrary task) {
                    task.setDescription("Creates " + binary.getDisplayName());
                    task.setToolChain(binary.getToolChain());
                    task.setTargetPlatform(binary.getTargetPlatform());
                    task.setOutputFile(binary.getStaticLibraryFile());
                    task.setStaticLibArgs(binary.getStaticLibArchiver().getArgs());
                }
            });
        }

        @BinaryTasks
        public void executableTasks(ModelMap<Task> tasks, NativeExecutableBinarySpecInternal executableBinary) {
            NativeComponents.createExecutableTask(executableBinary, executableBinary.getExecutable().getFile());
        }

        @Defaults
        void createInstallTasks(ModelMap<Task> tasks, ModelMap<NativeBinarySpecInternal> binaries) {
            for (NativeExecutableBinarySpecInternal binary : binaries.withType(NativeExecutableBinarySpecInternal.class).values()) {
                NativeComponents.createInstallTask(binary, binary.getInstallation(), binary.getExecutable(), binary.getNamingScheme());
            }
        }
    }
}

