/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.ComponentRenderer;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.logging.StyledTextOutput;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.reporting.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentReportRenderer
extends TextReportRenderer {
    private final ComponentRenderer componentRenderer;
    private final SourceSetRenderer sourceSetRenderer;
    private final TypeAwareBinaryRenderer binaryRenderer;
    private final Set<LanguageSourceSet> componentSourceSets = new HashSet<LanguageSourceSet>();
    private final Set<BinarySpec> componentBinaries = new HashSet<BinarySpec>();

    public ComponentReportRenderer(FileResolver fileResolver, TypeAwareBinaryRenderer binaryRenderer) {
        this.setFileResolver(fileResolver);
        this.sourceSetRenderer = new SourceSetRenderer();
        this.binaryRenderer = binaryRenderer;
        this.componentRenderer = new ComponentRenderer(this.sourceSetRenderer, binaryRenderer);
    }

    @Override
    public void complete() {
        this.getTextOutput().println();
        this.getTextOutput().println((Object)"Note: currently not all plugins register their components, so some components may not be visible here.");
        super.complete();
    }

    public void renderComponents(Collection<ComponentSpec> components) {
        if (components.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No components defined for this project.");
            return;
        }
        boolean seen = false;
        for (ComponentSpec component : components) {
            if (seen) {
                this.getBuilder().getOutput().println();
            } else {
                seen = true;
            }
            this.getBuilder().item(component, this.componentRenderer);
            this.componentSourceSets.addAll(component.getSources().values());
            this.componentBinaries.addAll(component.getBinaries().values());
        }
    }

    public void renderSourceSets(Collection<LanguageSourceSet> sourceSets) {
        Set<LanguageSourceSet> additionalSourceSets = this.collectAdditionalSourceSets(sourceSets);
        this.outputCollection(additionalSourceSets, "Additional source sets", this.sourceSetRenderer, "source sets");
    }

    public void renderBinaries(Iterable<BinarySpec> binaries) {
        Set<BinarySpec> additionalBinaries = this.collectAdditionalBinaries(binaries);
        this.outputCollection(additionalBinaries, "Additional binaries", this.binaryRenderer, "binaries");
    }

    private Set<LanguageSourceSet> collectAdditionalSourceSets(Collection<LanguageSourceSet> sourceSets) {
        return ComponentReportRenderer.elementsNotIn(this.componentSourceSets, sourceSets, SourceSetRenderer.SORT_ORDER);
    }

    private Set<BinarySpec> collectAdditionalBinaries(Iterable<BinarySpec> binaries) {
        return ComponentReportRenderer.elementsNotIn(this.componentBinaries, binaries, TypeAwareBinaryRenderer.SORT_ORDER);
    }

    private static <T> Set<T> elementsNotIn(Set<T> set, Iterable<T> elements, Comparator<? super T> comparator) {
        TreeSet result = Sets.newTreeSet(comparator);
        for (T element : elements) {
            if (set.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    private <T> void outputCollection(Collection<? extends T> items, String title, ReportRenderer<T, TextReportBuilder> renderer, String elementsPlural) {
        if (!items.isEmpty()) {
            this.getBuilder().getOutput().println();
            this.getBuilder().collection(title, items, renderer, elementsPlural);
        }
    }
}

