/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks.api.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.SortedSet;
import org.gradle.jvm.tasks.api.internal.AnnotationAnnotationValue;
import org.gradle.jvm.tasks.api.internal.AnnotationMember;
import org.gradle.jvm.tasks.api.internal.AnnotationValue;
import org.gradle.jvm.tasks.api.internal.ArrayAnnotationValue;
import org.gradle.jvm.tasks.api.internal.ClassMember;
import org.gradle.jvm.tasks.api.internal.EnumAnnotationValue;
import org.gradle.jvm.tasks.api.internal.FieldMember;
import org.gradle.jvm.tasks.api.internal.InnerClassMember;
import org.gradle.jvm.tasks.api.internal.MethodMember;
import org.gradle.jvm.tasks.api.internal.ParameterAnnotationMember;
import org.gradle.jvm.tasks.api.internal.SimpleAnnotationValue;
import org.gradle.jvm.tasks.api.internal.SortingAnnotationVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiMemberSelector
extends ClassVisitor {
    private final SortedSet<MethodMember> methods = Sets.newTreeSet();
    private final SortedSet<FieldMember> fields = Sets.newTreeSet();
    private final SortedSet<InnerClassMember> innerClasses = Sets.newTreeSet();
    private final ClassVisitor apiMemberAdapter;
    private final boolean apiIncludesPackagePrivateMembers;
    private boolean isInnerClass;
    private ClassMember classMember;

    public ApiMemberSelector(ClassVisitor apiMemberAdapter, boolean apiIncludesPackagePrivateMembers) {
        super(327680);
        this.apiMemberAdapter = apiMemberAdapter;
        this.apiIncludesPackagePrivateMembers = apiIncludesPackagePrivateMembers;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classMember = new ClassMember(version, access, name, signature, superName, interfaces);
        this.isInnerClass = (access & 0x20) == 32;
    }

    public void visitEnd() {
        super.visitEnd();
        this.apiMemberAdapter.visit(this.classMember.getVersion(), this.classMember.getAccess(), this.classMember.getName(), this.classMember.getSignature(), this.classMember.getSuperName(), this.classMember.getInterfaces());
        this.visitAnnotationMembers(this.classMember.getAnnotations());
        for (MethodMember method : this.methods) {
            MethodVisitor mv = this.apiMemberAdapter.visitMethod(method.getAccess(), method.getName(), method.getTypeDesc(), method.getSignature(), method.getExceptions().toArray(new String[method.getExceptions().size()]));
            this.visitAnnotationMembers(mv, method.getAnnotations());
            this.visitAnnotationMembers(mv, method.getParameterAnnotations());
            mv.visitEnd();
        }
        for (FieldMember field : this.fields) {
            FieldVisitor fieldVisitor = this.apiMemberAdapter.visitField(field.getAccess(), field.getName(), field.getTypeDesc(), field.getSignature(), null);
            this.visitAnnotationMembers(fieldVisitor, field.getAnnotations());
            fieldVisitor.visitEnd();
        }
        for (InnerClassMember innerClass : this.innerClasses) {
            this.apiMemberAdapter.visitInnerClass(innerClass.getName(), innerClass.getOuterName(), innerClass.getInnerName(), innerClass.getAccess());
        }
        this.apiMemberAdapter.visitEnd();
    }

    private void visitAnnotationMembers(Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = this.apiMemberAdapter.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.visitAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void visitAnnotationMembers(MethodVisitor mv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = annotation instanceof ParameterAnnotationMember ? mv.visitParameterAnnotation(((ParameterAnnotationMember)annotation).getParameter(), annotation.getName(), annotation.isVisible()) : mv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.visitAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void visitAnnotationMembers(FieldVisitor fv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = fv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.visitAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void visitAnnotationValues(AnnotationMember annotation, AnnotationVisitor annotationVisitor) {
        for (AnnotationValue annotationValue : annotation.getValues()) {
            this.visitAnnotationValue(annotationVisitor, annotationValue);
        }
        annotationVisitor.visitEnd();
    }

    private void visitAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue<?> value) {
        String name = value.getName();
        if (value instanceof EnumAnnotationValue) {
            annotationVisitor.visitEnum(name, ((EnumAnnotationValue)value).getTypeDesc(), (String)value.getValue());
        } else if (value instanceof SimpleAnnotationValue) {
            annotationVisitor.visit(name, value.getValue());
        } else if (value instanceof ArrayAnnotationValue) {
            AnnotationValue[] values;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (AnnotationValue annotationValue : values = (AnnotationValue[])((ArrayAnnotationValue)value).getValue()) {
                this.visitAnnotationValue(arrayVisitor, annotationValue);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof AnnotationAnnotationValue) {
            AnnotationMember annotation = (AnnotationMember)((AnnotationAnnotationValue)value).getValue();
            AnnotationVisitor annVisitor = annotationVisitor.visitAnnotation(name, annotation.getName());
            this.visitAnnotationValues(annotation, annVisitor);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationMember ann = new AnnotationMember(desc, visible);
        this.classMember.addAnnotation(ann);
        return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            return null;
        }
        if (ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers) || "<init>".equals(name) && this.isInnerClass) {
            final MethodMember methodMember = new MethodMember(access, name, desc, signature, exceptions);
            this.methods.add(methodMember);
            return new MethodVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationMember ann = new AnnotationMember(desc, visible);
                    methodMember.addAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    ParameterAnnotationMember ann = new ParameterAnnotationMember(desc, visible, parameter);
                    methodMember.addParameterAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitParameterAnnotation(parameter, desc, visible));
                }
            };
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers)) {
            final FieldMember fieldMember = new FieldMember(access, name, signature, desc);
            this.fields.add(fieldMember);
            return new FieldVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationMember ann = new AnnotationMember(desc, visible);
                    fieldMember.addAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
                }
            };
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (innerName == null) {
            return;
        }
        if (!this.apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(access)) {
            return;
        }
        this.innerClasses.add(new InnerClassMember(access, name, outerName, innerName));
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public static boolean isCandidateApiMember(int access, boolean apiIncludesPackagePrivateMembers) {
        return ApiMemberSelector.isPublicMember(access) || ApiMemberSelector.isProtectedMember(access) || apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(access);
    }

    private static boolean isPublicMember(int access) {
        return (access & 1) == 1;
    }

    private static boolean isProtectedMember(int access) {
        return (access & 4) == 4;
    }

    private static boolean isPackagePrivateMember(int access) {
        return access == 0 || access == 8 || access == 32 || access == 40;
    }
}

