/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.lang.management.ManagementFactory;
import org.gradle.StartParameter;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.cli.CommandLineAction;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.RunBuildAction;
import org.gradle.launcher.cli.StopDaemonAction;
import org.gradle.launcher.daemon.bootstrap.ForegroundDaemonAction;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.client.JvmVersionDetector;
import org.gradle.launcher.daemon.configuration.CurrentProcess;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.ForegroundDaemonConfiguration;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;
import org.gradle.launcher.exec.DaemonUsageSuggestingBuildActionExecuter;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.OutputEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildActionsFactory
implements CommandLineAction {
    private final CommandLineConverter<Parameters> parametersConverter;
    private final ServiceRegistry loggingServices;

    BuildActionsFactory(ServiceRegistry loggingServices, CommandLineConverter<Parameters> parametersConverter) {
        this.loggingServices = loggingServices;
        this.parametersConverter = parametersConverter;
    }

    @Override
    public void configureCommandLineParser(CommandLineParser parser) {
        this.parametersConverter.configure(parser);
    }

    @Override
    public Runnable createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
        Parameters parameters = (Parameters)this.parametersConverter.convert(commandLine, (Object)new Parameters());
        parameters.getDaemonParameters().applyDefaultsFor(new JvmVersionDetector().getJavaVersion(parameters.getDaemonParameters().getEffectiveJvm()));
        if (parameters.getDaemonParameters().isStop()) {
            return this.stopAllDaemons(parameters.getDaemonParameters(), this.loggingServices);
        }
        if (parameters.getDaemonParameters().isForeground()) {
            DaemonParameters daemonParameters = parameters.getDaemonParameters();
            ForegroundDaemonConfiguration conf = new ForegroundDaemonConfiguration(daemonParameters.getUid(), daemonParameters.getBaseDir(), daemonParameters.getIdleTimeout());
            return new ForegroundDaemonAction(this.loggingServices, conf);
        }
        if (parameters.getDaemonParameters().getDaemonUsage().isEnabled()) {
            return this.runBuildWithDaemon(parameters.getStartParameter(), parameters.getDaemonParameters(), this.loggingServices);
        }
        if (this.canUseCurrentProcess(parameters.getDaemonParameters())) {
            return this.runBuildInProcess(parameters.getStartParameter(), parameters.getDaemonParameters(), this.loggingServices);
        }
        return this.runBuildInSingleUseDaemon(parameters.getStartParameter(), parameters.getDaemonParameters(), this.loggingServices);
    }

    private Runnable stopAllDaemons(DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createStopDaemonServices(loggingServices.get(OutputEventListener.class), daemonParameters);
        DaemonStopClient stopClient = clientServices.get(DaemonStopClient.class);
        return new StopDaemonAction(stopClient);
    }

    private Runnable runBuildWithDaemon(StartParameter startParameter, DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createBuildClientServices(loggingServices.get(OutputEventListener.class), daemonParameters, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.runBuild(startParameter, daemonParameters, client, clientSharedServices);
    }

    private boolean canUseCurrentProcess(DaemonParameters requiredBuildParameters) {
        CurrentProcess currentProcess = new CurrentProcess();
        return currentProcess.configureForBuild(requiredBuildParameters);
    }

    private Runnable runBuildInProcess(StartParameter startParameter, DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        ServiceRegistry globalServices = ServiceRegistryBuilder.builder().displayName("Global services").parent(loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).provider(new GlobalScopeServices(startParameter.isContinuous())).build();
        BuildActionExecuter executer = globalServices.get(BuildExecuter.class);
        StyledTextOutputFactory textOutputFactory = globalServices.get(StyledTextOutputFactory.class);
        DocumentationRegistry documentationRegistry = globalServices.get(DocumentationRegistry.class);
        DaemonUsageSuggestingBuildActionExecuter daemonUsageSuggestingExecuter = new DaemonUsageSuggestingBuildActionExecuter(executer, textOutputFactory, documentationRegistry);
        return this.runBuild(startParameter, daemonParameters, daemonUsageSuggestingExecuter, globalServices);
    }

    private Runnable runBuildInSingleUseDaemon(StartParameter startParameter, DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        int maxTimeout = 120000;
        if (daemonParameters.getIdleTimeout() > maxTimeout) {
            daemonParameters.setIdleTimeout(maxTimeout);
        }
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createSingleUseDaemonClientServices(loggingServices.get(OutputEventListener.class), daemonParameters, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.runBuild(startParameter, daemonParameters, client, clientSharedServices);
    }

    private ServiceRegistry createGlobalClientServices() {
        return ServiceRegistryBuilder.builder().displayName("Daemon client global services").parent((ServiceRegistry)NativeServices.getInstance()).provider(new GlobalScopeServices(false)).provider(new DaemonClientGlobalServices()).build();
    }

    private Runnable runBuild(StartParameter startParameter, DaemonParameters daemonParameters, BuildActionExecuter<BuildActionParameters> executer, ServiceRegistry sharedServices) {
        DefaultBuildActionParameters parameters = new DefaultBuildActionParameters(daemonParameters.getEffectiveSystemProperties(), System.getenv(), SystemProperties.getInstance().getCurrentDir(), startParameter.getLogLevel(), daemonParameters.getDaemonUsage(), startParameter.isContinuous(), daemonParameters.isInteractive(), ClassPath.EMPTY);
        return new RunBuildAction(executer, startParameter, this.clientMetaData(), this.getBuildStartTime(), parameters, sharedServices);
    }

    private long getBuildStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }
}

