/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Cast;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.NamedLanguageRegistration;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.model.internal.core.BaseInstanceFactory;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.ComponentSpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageSourceSetFactory
extends BaseInstanceFactory<LanguageSourceSet> {
    private final List<LanguageRegistration<?>> languageRegistrations = Lists.newArrayList();
    private final FileResolver fileResolver;

    public LanguageSourceSetFactory(String displayName, FileResolver fileResolver) {
        super(displayName, LanguageSourceSet.class, BaseLanguageSourceSet.class);
        this.fileResolver = fileResolver;
    }

    public <T extends LanguageSourceSet, V extends LanguageSourceSet> void register(String languageName, ModelType<T> type, Set<Class<?>> internalViews, final ModelType<V> implementationType, ModelRuleDescriptor ruleDescriptor) {
        InstanceFactory.TypeRegistrationBuilder registration = this.register(type, ruleDescriptor);
        if (implementationType != null) {
            registration.withImplementation((ModelType)Cast.uncheckedCast(implementationType), new InstanceFactory.ImplementationFactory<T>(){

                public T create(ModelType<? extends T> publicType, String sourceSetName, MutableModelNode modelNode) {
                    return (LanguageSourceSet)Cast.uncheckedCast(BaseLanguageSourceSet.create(publicType.getConcreteClass(), implementationType.getConcreteClass(), sourceSetName, LanguageSourceSetFactory.this.determineParentName(modelNode), LanguageSourceSetFactory.this.fileResolver));
                }
            });
        }
        for (Class<?> internalView : internalViews) {
            registration.withInternalView(ModelType.of(internalView));
        }
        if (!StringUtils.isEmpty((String)languageName)) {
            this.languageRegistrations.add(new NamedLanguageRegistration<T>(languageName, type));
        }
    }

    public Collection<LanguageRegistration<?>> getRegistrations() {
        return ImmutableList.copyOf(this.languageRegistrations);
    }

    private String determineParentName(MutableModelNode modelNode) {
        MutableModelNode grandparentNode = modelNode.getParent().getParent();
        if (grandparentNode != null) {
            if (grandparentNode.getPrivateData() instanceof BaseBinarySpec) {
                BaseBinarySpec binarySpecInternal = (BaseBinarySpec)grandparentNode.getPrivateData();
                return binarySpecInternal.getComponent() == null ? binarySpecInternal.getName() : binarySpecInternal.getComponent().getName();
            }
            if (grandparentNode.getPrivateData() instanceof ComponentSpecInternal) {
                return ((ComponentSpecInternal)grandparentNode.getPrivateData()).getName();
            }
        }
        return modelNode.getParent().getPath().getName();
    }
}

