/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.model.BinarySourceTransformations;
import org.gradle.language.base.internal.model.ComponentRules;
import org.gradle.language.base.internal.registry.DefaultLanguageTransformContainer;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.FactoryBasedStructNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.PlatformAwareComponentSpec;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.component.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultPlatformContainer;
import org.gradle.platform.base.internal.DefaultPlatformResolvers;
import org.gradle.platform.base.internal.PlatformAwareComponentSpecInternal;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.platform.base.plugins.BinaryBasePlugin;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;

    @Inject
    public ComponentModelBasePlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        project.getPluginManager().apply(BinaryBasePlugin.class);
        this.modelRegistry.getRoot().applyTo(NodePredicate.allDescendants((Predicate)ModelNodes.withType(ComponentSpec.class)), ComponentRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Hidden
        @Model
        ComponentSpecFactory componentSpecFactory(ProjectIdentifier projectIdentifier) {
            return new ComponentSpecFactory("components", projectIdentifier);
        }

        @ComponentType
        void registerBaseComponentSpec(ComponentTypeBuilder<ComponentSpec> builder) {
            builder.defaultImplementation(BaseComponentSpec.class);
            builder.internalView(ComponentSpecInternal.class);
        }

        @ComponentType
        void registerPlatformAwareComponet(ComponentTypeBuilder<PlatformAwareComponentSpec> builder) {
            builder.internalView(PlatformAwareComponentSpecInternal.class);
        }

        @Model
        void components(ComponentSpecContainer componentSpecs) {
        }

        @Mutate
        void registerNodeInitializerExtractors(NodeInitializerRegistry nodeInitializerRegistry, ComponentSpecFactory componentSpecFactory, ModelSchemaStore schemaStore, StructBindingsStore bindingsStore) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedStructNodeInitializerExtractionStrategy((InstanceFactory)componentSpecFactory, schemaStore, bindingsStore));
        }

        @Hidden
        @Model
        LanguageTransformContainer languageTransforms() {
            return new DefaultLanguageTransformContainer();
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, ModelMap<BinarySpecInternal> binaries, LanguageTransformContainer languageTransforms, ServiceRegistry serviceRegistry) {
            BinarySourceTransformations transformations = new BinarySourceTransformations(tasks, languageTransforms, serviceRegistry);
            for (BinarySpecInternal binary : binaries) {
                if (binary.isLegacyBinary()) continue;
                transformations.createTasksFor(binary);
            }
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{instantiator});
        }

        @Hidden
        @Model
        PlatformResolvers platformResolver(PlatformContainer platforms) {
            return new DefaultPlatformResolvers(platforms);
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add("platforms", (Object)platforms);
        }

        @Mutate
        void collectBinaries(BinaryContainer binaries, ComponentSpecContainer componentSpecs) {
            for (ComponentSpec componentSpec : componentSpecs.values()) {
                for (BinarySpecInternal binary : componentSpec.getBinaries().withType(BinarySpecInternal.class).values()) {
                    binaries.put(binary.getProjectScopedName(), binary);
                }
            }
        }

        @Validate
        void validateComponentSpecRegistrations(ComponentSpecFactory instanceFactory) {
            instanceFactory.validateRegistrations();
        }

        @Mutate
        void attachBinariesToAssembleLifecycle(@Path(value="tasks.assemble") Task assemble, ComponentSpecContainer components) {
            ArrayList notBuildable = Lists.newArrayList();
            boolean hasBuildableBinaries = false;
            Iterator i$ = components.iterator();
            while (i$.hasNext()) {
                ComponentSpec component = (ComponentSpec)i$.next();
                for (BinarySpecInternal binary : component.getBinaries().withType(BinarySpecInternal.class)) {
                    if (binary.isBuildable()) {
                        assemble.dependsOn(new Object[]{binary});
                        hasBuildableBinaries = true;
                        continue;
                    }
                    notBuildable.add(binary);
                }
            }
            if (!hasBuildableBinaries && !notBuildable.isEmpty()) {
                assemble.doFirst((Action)new CheckForNotBuildableBinariesAction(notBuildable));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckForNotBuildableBinariesAction
        implements Action<Task> {
            private final List<BinarySpecInternal> notBuildable;

            public CheckForNotBuildableBinariesAction(List<BinarySpecInternal> notBuildable) {
                this.notBuildable = notBuildable;
            }

            public void execute(Task task) {
                Set taskDependencies = task.getTaskDependencies().getDependencies(task);
                if (taskDependencies.isEmpty()) {
                    TreeFormatter formatter = new TreeFormatter();
                    formatter.node("No buildable binaries found");
                    formatter.startChildren();
                    for (BinarySpecInternal binary : this.notBuildable) {
                        formatter.node(binary.getDisplayName());
                        formatter.startChildren();
                        binary.getBuildAbility().explain((TreeVisitor<? super String>)formatter);
                        formatter.endChildren();
                    }
                    formatter.endChildren();
                    throw new GradleException(formatter.toString());
                }
            }
        }
    }
}

