/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.binary.internal;

import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.model.Finalize;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class BaseBinaryRules
extends RuleSource {
    @Finalize
    public void defineBuildLifecycleTask(BinarySpecInternal binary, ITaskFactory taskFactory) {
        if (!binary.isLegacyBinary()) {
            TaskInternal binaryLifecycleTask = (TaskInternal)taskFactory.create(binary.getProjectScopedName(), DefaultTask.class);
            binaryLifecycleTask.setGroup("build");
            binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
            binary.setBuildTask((Task)binaryLifecycleTask);
        }
    }

    @Finalize
    void addSourceSetsOwnedByBinariesToTheirInputs(BinarySpecInternal binary) {
        if (binary.isLegacyBinary()) {
            return;
        }
        binary.getInputs().addAll(binary.getSources().values());
    }
}

