/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.logging;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractStdListener
implements LogListener {
    private boolean errors = false;

    public void logEvent(LogEvent logEvent) {
        if (logEvent.getEventKind() == 7) {
            this.errors = true;
        }
        if (this.skipEvent(logEvent)) {
            return;
        }
        ArrayList arrayList = AbstractStdListener.formatOutput(logEvent, true, !EhiLogger.getInstance().getTraceFilter());
        this.outputEvent(logEvent, arrayList);
    }

    public void outputEvent(LogEvent logEvent, ArrayList arrayList) {
        String string = this.getMessageTag(logEvent);
        string = string == null ? "" : string + ": ";
        String string2 = this.getTimestamp();
        string2 = string2 == null ? "" : string2 + ": ";
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            this.outputMsgLine(logEvent.getEventKind(), logEvent.getCustomLevel(), string2 + string + string3);
        }
    }

    public boolean skipEvent(LogEvent logEvent) {
        return false;
    }

    public abstract void outputMsgLine(int var1, int var2, String var3);

    public String getMessageTag(LogEvent logEvent) {
        return logEvent.getEventKind() == 7 ? null : "Info";
    }

    public String getTimestamp() {
        return null;
    }

    public static String fmtOriginMsg(StackTraceElement stackTraceElement, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stackTraceElement.getMethodName());
        stringBuffer.append("(): ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        String string2 = stackTraceElement.getFileName();
        if (string2 != null) {
            stringBuffer.append(string2);
            int n = stackTraceElement.getLineNumber();
            if (n >= 0) {
                stringBuffer.append(":");
                stringBuffer.append(Integer.toString(n));
            }
        } else {
            stringBuffer.append(stackTraceElement.getClassName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static ArrayList formatOutput(LogEvent logEvent, boolean bl, boolean bl2) {
        Throwable throwable;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = logEvent.getEventMsg();
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        String string2 = "";
        if (string != null) {
            StackTraceElement stackTraceElement;
            int n;
            if (bl && ((n = logEvent.getEventKind()) == 1 || n == 2 || n == 3 || n == 4) && (stackTraceElement = logEvent.getOrigin()) != null) {
                string = AbstractStdListener.fmtOriginMsg(stackTraceElement, string);
            }
            arrayList.add(string);
            string2 = "  ";
        }
        if ((throwable = logEvent.getException()) != null) {
            AbstractStdListener.logThrowable(arrayList, string2, throwable, bl2);
        }
        return arrayList;
    }

    private static void logThrowable(ArrayList arrayList, String string, Throwable throwable, boolean bl) {
        InvocationTargetException invocationTargetException;
        SQLException sQLException;
        Throwable throwable2;
        Object object;
        String string2 = throwable.getLocalizedMessage();
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            string2 = throwable.getClass().getName();
        }
        arrayList.add(string + string2);
        if (bl) {
            object = throwable.getStackTrace();
            for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                arrayList.add(string + "    " + object[i].toString());
            }
        }
        if ((object = throwable.getCause()) != null) {
            AbstractStdListener.logThrowable(arrayList, string + "  ", (Throwable)object, bl);
        }
        if (throwable instanceof SQLException && (throwable2 = (sQLException = (SQLException)throwable).getNextException()) != null) {
            AbstractStdListener.logThrowable(arrayList, string + "  ", throwable2, bl);
        }
        if (throwable instanceof InvocationTargetException && (throwable2 = (invocationTargetException = (InvocationTargetException)throwable).getTargetException()) != null) {
            AbstractStdListener.logThrowable(arrayList, string + "  ", throwable2, bl);
        }
    }

    public boolean hasSeenErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors = false;
    }
}

