/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.split;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.module.PdfsamModule;
import org.pdfsam.split.SplitOptionsPane;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.support.params.SinglePdfSourceMultipleOutputParametersBuilder;
import org.pdfsam.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.ui.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.prefix.PrefixPane;
import org.pdfsam.ui.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.MultipleOutputTaskParameters;
import org.sejda.model.parameter.base.SinglePdfSourceTaskParameters;
import org.sejda.model.prefix.Prefix;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@PdfsamModule
public class SplitModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "split.simple";
    private TaskParametersBuilderSingleSelectionPane selectionPane;
    private BrowsableOutputDirectoryField destinationDirectoryField;
    private PdfDestinationPane destinationPane;
    private SplitOptionsPane splitOptions = new SplitOptionsPane();
    private PrefixPane prefix = new PrefixPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.SPLIT).name(DefaultI18nContext.getInstance().i18n("Split")).description(DefaultI18nContext.getInstance().i18n("Split a PDF document at the given page numbers.")).priority(ModulePriority.HIGH.getPriority()).supportURL("http://www.pdfsam.org/pdf-split").build();

    @Inject
    public SplitModule(@Named(value="split.simplefield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="split.simplepane") PdfDestinationPane destinationPane) {
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(DefaultI18nContext.getInstance().i18n("Select or drag and drop the PDF you want to split"));
        this.selectionPane.addOnLoaded(d -> this.splitOptions.setMaxPages(d.pages().getValue()));
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.splitOptions.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo((Map)data);
        this.destinationPane.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    @Override
    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.splitOptions.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom((Map)data);
        this.destinationPane.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    protected Builder<? extends AbstractSplitByPageParameters> getBuilder(Consumer<String> onError) {
        Optional<SinglePdfSourceMultipleOutputParametersBuilder<? extends AbstractSplitByPageParameters>> builder = Optional.ofNullable(this.splitOptions.getBuilder(onError));
        builder.ifPresent(b -> {
            this.selectionPane.apply((SinglePdfSourceTaskParametersBuilder<? extends SinglePdfSourceTaskParameters>)b, onError);
            this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder<? extends MultipleOutputTaskParameters>)b, onError);
            this.destinationPane.apply((AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters>)b, onError);
            this.prefix.apply((MultipleOutputTaskParametersBuilder<?>)b, onError);
        });
        return builder.orElse(null);
    }

    @Override
    protected Pane getInnerPanel(Pane footer) {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        TitledPane prefixTitled = Views.titledPane(DefaultI18nContext.getInstance().i18n("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(Prefix.CURRENTPAGE);
        this.prefix.addMenuItemFor(Prefix.FILENUMBER);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane(DefaultI18nContext.getInstance().i18n("Split settings"), (Node)this.splitOptions), Views.titledPane(DefaultI18nContext.getInstance().i18n("Destination directory"), (Node)this.destinationPane), prefixTitled, footer});
        return pane;
    }

    @Override
    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @Override
    public Node graphic() {
        return new ImageView("split.png");
    }

    @Configuration
    public static class ModuleConfig {
        @Bean(name={"split.simplefield"})
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Bean(name={"split.simplepane"})
        public PdfDestinationPane destinationPane(@Named(value="split.simplefield") BrowsableOutputDirectoryField outputField, UserContext userContext) {
            PdfDestinationPane panel = new PdfDestinationPane(outputField, SplitModule.MODULE_ID, userContext);
            panel.enableSameAsSourceItem();
            return panel;
        }
    }
}

