/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.output.ExistingOutputPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OutputWriterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OutputWriterHelper.class);

    private OutputWriterHelper() {
    }

    static void moveToFile(Map<String, File> files, File outputFile, ExistingOutputPolicy existingOutputPolicy) throws IOException {
        if (outputFile.exists() && !outputFile.isFile()) {
            throw new IOException(String.format("Wrong output destination %s, must be a file.", outputFile));
        }
        if (files.size() != 1) {
            throw new IOException(String.format("Wrong files map size %d, must be 1 to copy to the selected destination %s", files.size(), outputFile));
        }
        for (Map.Entry<String, File> entry : files.entrySet()) {
            OutputWriterHelper.moveFile(entry.getValue(), outputFile, Optional.of(existingOutputPolicy).filter(p -> p != ExistingOutputPolicy.SKIP).orElseGet(() -> {
                LOG.debug("Cannot use {} output policy for single output, replaced with {}", (Object)ExistingOutputPolicy.SKIP, (Object)ExistingOutputPolicy.FAIL);
                return ExistingOutputPolicy.FAIL;
            }));
        }
    }

    static void moveToDirectory(Map<String, File> files, File outputDirectory, ExistingOutputPolicy existingOutputPolicy) throws IOException {
        if (!outputDirectory.isDirectory()) {
            throw new IOException(String.format("Wrong output destination %s, must be a directory.", outputDirectory));
        }
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new IOException(String.format("Unable to make destination directory tree %s.", outputDirectory));
        }
        for (Map.Entry<String, File> entry : files.entrySet()) {
            if (StringUtils.isBlank(entry.getKey())) {
                throw new IOException(String.format("Unable to move %s to the output directory, no output name specified.", entry.getValue()));
            }
            OutputWriterHelper.moveFile(entry.getValue(), new File(outputDirectory, entry.getKey()), existingOutputPolicy);
        }
    }

    private static void moveFile(File input, File output, ExistingOutputPolicy existingOutputPolicy) throws IOException {
        block5: {
            block4: {
                if (!output.exists()) break block4;
                switch (existingOutputPolicy) {
                    case OVERWRITE: {
                        LOG.debug("Moving {} to {}.", (Object)input, (Object)output);
                        FileUtils.deleteQuietly(output);
                        FileUtils.moveFile(input, output);
                        break block5;
                    }
                    case SKIP: {
                        LOG.info("Skipping already existing output file {}", (Object)output);
                        break block5;
                    }
                    default: {
                        throw new IOException(String.format("Unable to write %s to the already existing file destination %s. (policy is %s)", input, output, existingOutputPolicy));
                    }
                }
            }
            LOG.debug("Moving {} to {}.", (Object)input, (Object)output);
            FileUtils.moveFile(input, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyToStreamZipped(Map<String, File> files, OutputStream out) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        for (Map.Entry<String, File> entry : files.entrySet()) {
            FileInputStream input = null;
            if (StringUtils.isBlank(entry.getKey())) {
                throw new IOException(String.format("Unable to copy %s to the output stream, no output name specified.", entry.getValue()));
            }
            try {
                input = new FileInputStream(entry.getValue());
                zipOut.putNextEntry(new ZipEntry(entry.getKey()));
                LOG.debug("Copying {} to zip stream {}.", (Object)entry.getValue(), (Object)entry.getKey());
                IOUtils.copy((InputStream)input, (OutputStream)zipOut);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                OutputWriterHelper.delete(entry.getValue());
                throw throwable;
            }
            IOUtils.closeQuietly(input);
            OutputWriterHelper.delete(entry.getValue());
        }
        IOUtils.closeQuietly(zipOut);
    }

    static void copyToStream(File file, OutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            IOUtils.copy((InputStream)in, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            OutputWriterHelper.delete(file);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        OutputWriterHelper.delete(file);
    }

    private static void delete(File file) {
        if (!file.delete()) {
            LOG.warn("Unable to delete temporary file {}", (Object)file);
        }
    }
}

