/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionGoTo;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutlineUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OutlineUtils.class);

    private OutlineUtils() {
    }

    public static int getMaxOutlineLevel(PDDocument document) {
        return OutlineUtils.getMaxOutlineLevel(document.getDocumentCatalog().getDocumentOutline(), document.getDocumentCatalog(), 0);
    }

    private static int getMaxOutlineLevel(PDOutlineNode node, PDDocumentCatalog catalog, int parentLevel) {
        int maxLevel = parentLevel;
        if (node != null) {
            for (PDOutlineItem current : node.children()) {
                int maxBookmarkBranchLevel;
                if (!OutlineUtils.isPageDestination(current, catalog) || (maxBookmarkBranchLevel = OutlineUtils.getMaxOutlineLevel(current, catalog, parentLevel + 1)) <= maxLevel) continue;
                maxLevel = maxBookmarkBranchLevel;
            }
        }
        return maxLevel;
    }

    public static Optional<PDPageDestination> toPageDestination(PDOutlineItem current, PDDocumentCatalog catalog) {
        try {
            PDAction outlineAction;
            PDDestination dest = current.getDestination();
            if (dest == null && (outlineAction = current.getAction()) instanceof PDActionGoTo) {
                dest = ((PDActionGoTo)outlineAction).getDestination();
            }
            if (dest instanceof PDNamedDestination && catalog != null) {
                dest = catalog.findNamedDestinationPage((PDNamedDestination)dest);
            }
            if (dest instanceof PDPageDestination) {
                return Optional.of((PDPageDestination)dest);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to get outline item destination ", e);
        }
        return Optional.empty();
    }

    private static boolean isPageDestination(PDOutlineItem current, PDDocumentCatalog catalog) {
        return OutlineUtils.toPageDestination(current, catalog).isPresent();
    }

    public static void copyOutlineDictionary(PDOutlineItem from, PDOutlineItem to) {
        to.setTitle(StringUtils.defaultString(from.getTitle()));
        to.setTextColor(from.getTextColor());
        to.setBold(from.isBold());
        to.setItalic(from.isItalic());
        if (from.isNodeOpen()) {
            to.openNode();
        } else {
            to.closeNode();
        }
    }
}

