/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.MultiValueMap;

public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final boolean nestedAnnotationsAsMap;

    public StandardAnnotationMetadata(Class<?> introspectedClass) {
        this(introspectedClass, false);
    }

    public StandardAnnotationMetadata(Class<?> introspectedClass, boolean nestedAnnotationsAsMap) {
        super(introspectedClass);
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Annotation[] anns;
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            types.add(ann.annotationType().getName());
        }
        return types;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationName) {
        return AnnotatedElementUtils.getMetaAnnotationTypes(this.getIntrospectedClass(), annotationName);
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            if (!ann.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationName) {
        return AnnotatedElementUtils.hasMetaAnnotationTypes(this.getIntrospectedClass(), annotationName);
    }

    @Override
    public boolean isAnnotated(String annotationName) {
        return AnnotatedElementUtils.isAnnotated(this.getIntrospectedClass(), annotationName);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationName) {
        return this.getAnnotationAttributes(annotationName, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(this.getIntrospectedClass(), annotationName, classValuesAsString, this.nestedAnnotationsAsMap);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName) {
        return this.getAllAnnotationAttributes(annotationName, false);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.getIntrospectedClass(), annotationName, classValuesAsString, this.nestedAnnotationsAsMap);
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationName) {
        Method[] methods;
        for (Method method : methods = this.getIntrospectedClass().getDeclaredMethods()) {
            if (method.isBridge() || !AnnotatedElementUtils.isAnnotated(method, annotationName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        Method[] methods = this.getIntrospectedClass().getDeclaredMethods();
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>();
        for (Method method : methods) {
            if (method.isBridge() || !AnnotatedElementUtils.isAnnotated(method, annotationName)) continue;
            annotatedMethods.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
        }
        return annotatedMethods;
    }
}

