/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanPositionRangeQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanFirstQuery
extends SpanPositionRangeQuery {
    public SpanFirstQuery(SpanQuery match, int end) {
        super(match, 0, end);
    }

    @Override
    protected FilterSpans.AcceptStatus acceptPosition(Spans spans) throws IOException {
        assert (spans.startPosition() != spans.endPosition()) : "start equals end: " + spans.startPosition();
        if (spans.startPosition() >= this.end) {
            return FilterSpans.AcceptStatus.NO_MORE_IN_CURRENT_DOC;
        }
        if (spans.endPosition() <= this.end) {
            return FilterSpans.AcceptStatus.YES;
        }
        return FilterSpans.AcceptStatus.NO;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }
}

