/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import org.apache.lucene.bkdtree3d.HeapReader;
import org.apache.lucene.bkdtree3d.Reader;
import org.apache.lucene.bkdtree3d.Writer;
import org.apache.lucene.util.ArrayUtil;

final class GrowingHeapWriter
implements Writer {
    int[] xs = new int[16];
    int[] ys = new int[16];
    int[] zs = new int[16];
    int[] docIDs = new int[16];
    long[] ords = new long[16];
    private int nextWrite;
    final int maxSize;

    public GrowingHeapWriter(int maxSize) {
        this.maxSize = maxSize;
    }

    private int[] growExact(int[] arr, int size) {
        assert (size > arr.length);
        int[] newArr = new int[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    private long[] growExact(long[] arr, int size) {
        assert (size > arr.length);
        long[] newArr = new long[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    @Override
    public void append(int x, int y, int z, long ord, int docID) {
        assert (ord == (long)this.nextWrite);
        if (this.xs.length == this.nextWrite) {
            int nextSize = Math.min(this.maxSize, ArrayUtil.oversize((int)(this.nextWrite + 1), (int)4));
            assert (nextSize > this.nextWrite) : "nextSize=" + nextSize + " vs nextWrite=" + this.nextWrite;
            this.xs = this.growExact(this.xs, nextSize);
            this.ys = this.growExact(this.ys, nextSize);
            this.zs = this.growExact(this.zs, nextSize);
            this.ords = this.growExact(this.ords, nextSize);
            this.docIDs = this.growExact(this.docIDs, nextSize);
        }
        this.xs[this.nextWrite] = x;
        this.ys[this.nextWrite] = y;
        this.zs[this.nextWrite] = z;
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public Reader getReader(long start) {
        return new HeapReader(this.xs, this.ys, this.zs, this.ords, this.docIDs, (int)start, this.nextWrite);
    }

    @Override
    public void close() {
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "GrowingHeapWriter(count=" + this.nextWrite + " alloc=" + this.xs.length + ")";
    }
}

