/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.geocentroid;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.GeoUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.geobounds.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.geocentroid.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public final class GeoCentroidAggregator
extends MetricsAggregator {
    private final ValuesSource.GeoPoint valuesSource;
    LongArray centroids;
    LongArray counts;

    protected GeoCentroidAggregator(String name, AggregationContext aggregationContext, Aggregator parent, ValuesSource.GeoPoint valuesSource, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, aggregationContext, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            BigArrays bigArrays = this.context.bigArrays();
            this.centroids = bigArrays.newLongArray(1L, true);
            this.counts = bigArrays.newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values = this.valuesSource.geoPointValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                GeoCentroidAggregator.this.centroids = bigArrays.grow(GeoCentroidAggregator.this.centroids, bucket + 1L);
                GeoCentroidAggregator.this.counts = bigArrays.grow(GeoCentroidAggregator.this.counts, bucket + 1L);
                values.setDocument(doc);
                int valueCount = values.count();
                if (valueCount > 0) {
                    double[] pt = new double[2];
                    long prevCounts = GeoCentroidAggregator.this.counts.get(bucket);
                    GeoCentroidAggregator.this.counts.increment(bucket, valueCount);
                    if (prevCounts > 0L) {
                        GeoPoint centroid = GeoPoint.fromIndexLong(GeoCentroidAggregator.this.centroids.get(bucket));
                        pt[0] = centroid.lon();
                        pt[1] = centroid.lat();
                    }
                    for (int i = 0; i < valueCount; ++i) {
                        GeoPoint value = values.valueAt(i);
                        pt[0] = pt[0] + (value.getLon() - pt[0]) / (double)(++prevCounts);
                        pt[1] = pt[1] + (value.getLat() - pt[1]) / (double)prevCounts;
                    }
                    GeoCentroidAggregator.this.centroids.set(bucket, GeoUtils.mortonHash((double)pt[0], (double)pt[1]));
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.centroids.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        GeoPoint bucketCentroid = bucketCount > 0L ? GeoPoint.fromIndexLong(this.centroids.get(bucket)) : new GeoPoint(Double.NaN, Double.NaN);
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.centroids, this.counts);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.GeoPoint> {
        protected Factory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config) {
            super(name, InternalGeoBounds.TYPE.name(), config);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new GeoCentroidAggregator(this.name, aggregationContext, parent, null, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.GeoPoint valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new GeoCentroidAggregator(this.name, aggregationContext, parent, valuesSource, pipelineAggregators, metaData);
        }
    }
}

