/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.io.File;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.ClassDirectoryBinarySpec;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassDirectoryBinarySpec
extends AbstractBuildableModelElement
implements ClassDirectoryBinarySpecInternal {
    private final DefaultDomainObjectSet<LanguageSourceSet> sourceSets = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private final String name;
    private final SourceSet sourceSet;
    private final JavaToolChain toolChain;
    private final JavaPlatform platform;
    private final BinaryTasksCollection tasks;
    private boolean buildable = true;

    public DefaultClassDirectoryBinarySpec(String name, SourceSet sourceSet, JavaToolChain toolChain, JavaPlatform platform, Instantiator instantiator, ITaskFactory taskFactory) {
        this.name = name;
        this.sourceSet = sourceSet;
        this.toolChain = toolChain;
        this.platform = platform;
        this.tasks = (BinaryTasksCollection)instantiator.newInstance(DefaultBinaryTasksCollection.class, new Object[]{this, taskFactory});
    }

    private String removeClassesSuffix(String name) {
        if (name.endsWith("Classes")) {
            return name.substring(0, name.length() - 7);
        }
        return name;
    }

    public LibraryBinaryIdentifier getId() {
        throw new UnsupportedOperationException();
    }

    public String getProjectScopedName() {
        return this.getName();
    }

    public Class<? extends BinarySpec> getPublicType() {
        return ClassDirectoryBinarySpec.class;
    }

    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    public JavaToolChain getToolChain() {
        return this.toolChain;
    }

    public JavaPlatform getTargetPlatform() {
        return this.platform;
    }

    public void setTargetPlatform(JavaPlatform platform) {
        throw new UnsupportedOperationException();
    }

    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    public boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public boolean isLegacyBinary() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public File getClassesDir() {
        return this.sourceSet.getOutput().getClassesDir();
    }

    public void setClassesDir(File classesDir) {
        this.sourceSet.getOutput().setClassesDir(classesDir);
    }

    public File getResourcesDir() {
        return this.sourceSet.getOutput().getResourcesDir();
    }

    public void setResourcesDir(File resourcesDir) {
        this.sourceSet.getOutput().setResourcesDir(resourcesDir);
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.getInputs();
    }

    public ModelMap<LanguageSourceSet> getSources() {
        throw new UnsupportedOperationException();
    }

    public BinaryNamingScheme getNamingScheme() {
        throw new UnsupportedOperationException();
    }

    public void setNamingScheme(BinaryNamingScheme namingScheme) {
        throw new UnsupportedOperationException();
    }

    public boolean hasCodependentSources() {
        throw new UnsupportedOperationException();
    }

    public DomainObjectSet<LanguageSourceSet> getInputs() {
        return this.sourceSets;
    }

    @Override
    public void addSourceSet(LanguageSourceSet sourceSet) {
        this.sourceSets.add((Object)sourceSet);
    }

    public String getDisplayName() {
        return "classes '" + this.removeClassesSuffix(this.name) + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public BinaryBuildAbility getBuildAbility() {
        if (!this.buildable) {
            return new FixedBuildAbility(false);
        }
        return new ToolSearchBuildAbility((ToolSearchResult)((JavaToolChainInternal)this.getToolChain()).select((Platform)this.getTargetPlatform()));
    }
}

