/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Nullable;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractMethodRuleAction;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeModelRuleExtractor<ANNOTATION extends Annotation, TYPE, BASEIMPL extends TYPE>
extends AbstractAnnotationDrivenComponentModelRuleExtractor<ANNOTATION> {
    private final String modelName;
    private final ModelType<TYPE> baseInterface;
    private final ModelType<BASEIMPL> baseImplementation;
    private final ModelType<?> builderInterface;
    private final ModelSchemaStore schemaStore;

    public TypeModelRuleExtractor(String modelName, Class<TYPE> baseInterface, Class<BASEIMPL> baseImplementation, Class<?> builderInterface, ModelSchemaStore schemaStore) {
        this.modelName = modelName;
        this.schemaStore = schemaStore;
        this.baseInterface = ModelType.of(baseInterface);
        this.baseImplementation = ModelType.of(baseImplementation);
        this.builderInterface = ModelType.of(builderInterface);
    }

    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        ModelType<TYPE> type = this.readType(ruleDefinition, (RuleSourceValidationProblemCollector)context);
        if (context.hasProblems()) {
            return null;
        }
        return this.createExtractedRule(ruleDefinition, type);
    }

    protected abstract <P extends TYPE> ExtractedModelRule createExtractedRule(MethodRuleDefinition<?, ?> var1, ModelType<P> var2);

    protected ModelType<? extends TYPE> readType(MethodRuleDefinition<?, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        this.validateIsVoidMethod(ruleDefinition, problems);
        if (ruleDefinition.getReferences().size() != 1) {
            problems.add(ruleDefinition, String.format("A method %s must have a single parameter of type %s.", this.getDescription(), this.builderInterface.toString()));
            return null;
        }
        ModelReference subjectReference = ruleDefinition.getSubjectReference();
        ModelType builder = subjectReference.getType();
        if (!this.builderInterface.isAssignableFrom(builder)) {
            problems.add(ruleDefinition, String.format("A method %s must have a single parameter of type %s.", this.getDescription(), this.builderInterface.toString()));
            return null;
        }
        if (builder.getTypeVariables().size() != 1) {
            problems.add(ruleDefinition, String.format("Parameter of type %s must declare a type parameter.", this.builderInterface.toString()));
            return null;
        }
        ModelType subType = (ModelType)builder.getTypeVariables().get(0);
        if (subType.isWildcard()) {
            problems.add(ruleDefinition, String.format("%s type '%s' cannot be a wildcard type (i.e. cannot use ? super, ? extends etc.).", StringUtils.capitalize((String)this.modelName), subType.toString()));
            return null;
        }
        if (!this.baseInterface.isAssignableFrom(subType)) {
            problems.add(ruleDefinition, String.format("%s type '%s' is not a subtype of '%s'.", StringUtils.capitalize((String)this.modelName), subType.toString(), this.baseInterface.toString()));
            return null;
        }
        return subType.asSubtype(this.baseInterface);
    }

    protected InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, InvalidModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(String.format(" is not a valid %s model rule method.", this.modelName));
        return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    protected ModelType<? extends BASEIMPL> determineImplementationType(ModelType<?> type, TypeBuilderInternal<?> builder) {
        for (Class<?> internalView : builder.getInternalViews()) {
            if (internalView.isInterface()) continue;
            throw new InvalidModelException(String.format("Internal view %s must be an interface.", internalView.getName()));
        }
        Class<?> implementation = builder.getDefaultImplementation();
        if (implementation == null) {
            return null;
        }
        ModelType implementationType = ModelType.of(implementation);
        if (!this.baseImplementation.isAssignableFrom(implementationType)) {
            throw new InvalidModelException(String.format("%s implementation %s must extend %s.", StringUtils.capitalize((String)this.modelName), implementationType, this.baseImplementation));
        }
        ModelType asSubclass = implementationType.asSubtype(this.baseImplementation);
        if (!type.isAssignableFrom(asSubclass)) {
            throw new InvalidModelException(String.format("%s implementation %s must implement %s.", StringUtils.capitalize((String)this.modelName), asSubclass, type));
        }
        for (Class<?> internalView : builder.getInternalViews()) {
            if (internalView.isAssignableFrom(implementation)) continue;
            throw new InvalidModelException(String.format("%s implementation %s must implement internal view %s.", StringUtils.capitalize((String)this.modelName), asSubclass, internalView.getName()));
        }
        try {
            asSubclass.getRawClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsmException) {
            throw new InvalidModelException(String.format("%s implementation %s must have public default constructor.", StringUtils.capitalize((String)this.modelName), asSubclass));
        }
        return asSubclass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ExtractedTypeRule<PUBLICTYPE, BUILDER extends TypeBuilderInternal<PUBLICTYPE>, REGISTRY>
    implements ExtractedModelRule {
        protected final MethodRuleDefinition<?, ?> ruleDefinition;
        protected final ModelType<PUBLICTYPE> publicType;

        public ExtractedTypeRule(MethodRuleDefinition<?, ?> ruleDefinition, ModelType<PUBLICTYPE> publicType) {
            this.ruleDefinition = ruleDefinition;
            this.publicType = publicType;
        }

        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            ModelReference subjectReference = ModelReference.of(this.getRegistryType());
            context.getRegistry().configure(ModelActionRole.Mutate, context.contextualize(this.ruleDefinition, (MethodRuleAction)new TypeRegistrationAction(subjectReference, this.ruleDefinition.getDescriptor())));
        }

        protected abstract Class<REGISTRY> getRegistryType();

        protected abstract void register(REGISTRY var1, ModelSchema<PUBLICTYPE> var2, BUILDER var3, ModelType<? extends BASEIMPL> var4);

        protected abstract BUILDER createBuilder(ModelSchema<PUBLICTYPE> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TypeRegistrationAction
        extends AbstractMethodRuleAction<REGISTRY> {
            public TypeRegistrationAction(ModelReference<REGISTRY> subject, ModelRuleDescriptor descriptor) {
                super(subject, descriptor);
            }

            public List<? extends ModelReference<?>> getInputs() {
                return Collections.emptyList();
            }

            protected void execute(ModelRuleInvoker<?> invoker, REGISTRY registry, List<ModelView<?>> inputs) {
                try {
                    ModelSchema schema = TypeModelRuleExtractor.this.schemaStore.getSchema(ExtractedTypeRule.this.publicType);
                    Object builder = ExtractedTypeRule.this.createBuilder(schema);
                    invoker.invoke(new Object[]{builder});
                    ModelType implModelType = TypeModelRuleExtractor.this.determineImplementationType(ExtractedTypeRule.this.publicType, (TypeBuilderInternal<?>)builder);
                    ExtractedTypeRule.this.register(registry, schema, builder, implModelType);
                }
                catch (InvalidModelException e) {
                    throw TypeModelRuleExtractor.this.invalidModelRule(ExtractedTypeRule.this.ruleDefinition, e);
                }
            }
        }
    }
}

