#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 0.10.12
id: dbus-0.10.12-4cc9298b2184d3c3fd49275732aea3bb
key: dbus_BZ3EUK0ByUV2Xb83m2Vo3m
license: GPL-3
maintainer: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Introspection DBus.Socket DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/dbus-0.10.12
library-dirs: /usr/lib/ghc-7.10.3/site-local/dbus-0.10.12
data-dir: /usr/share/arm-linux-ghc-7.10.3/dbus-0.10.12
hs-libraries: HSdbus-0.10.12-BZ3EUK0ByUV2Xb83m2Vo3m
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    cereal-0.5.1.0-2c7be146776a4abf674d1ac9e0ccfc13
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    libxml-sax-0.7.5-856c4308eb4976385a108d5795d6f217
    network-2.6.2.1-602ee4a12c5a174f6683a75303a065d3
    parsec-3.1.9-e73195cf6af19ee9d1587f67fa792c42
    random-1.1-41a0a7ecd483c665a5c3a093a5be2968
    text-1.2.2.0-2f82ea4adfdd656d9a8840ad2ee17cc0
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    unix-2.7.1.0-a583968f8d5891c6bf334fddb26b19a6
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
    xml-types-0.3.6-c95586b34c41769092e7d9cdd505a61e
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
