#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.3
id: HTTP-4000.3.3-7109897251a899dcae4c73aced404403
key: HTTP_FcTxZYuZP86Ihm2U4PRa0R
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
exposed-modules:
    Network.BufferType Network.Stream Network.StreamDebugger
    Network.StreamSocket Network.TCP Network.HTTP Network.HTTP.Headers
    Network.HTTP.Base Network.HTTP.Stream Network.HTTP.Auth
    Network.HTTP.Cookie Network.HTTP.Proxy Network.HTTP.HandleStream
    Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/HTTP-4000.3.3
library-dirs: /usr/lib/ghc-7.10.3/site-local/HTTP-4000.3.3
data-dir: /usr/share/arm-linux-ghc-7.10.3/HTTP-4000.3.3
hs-libraries: HSHTTP-4000.3.3-FcTxZYuZP86Ihm2U4PRa0R
depends:
    array-0.5.1.0-a4b4f31b03b7779670557ea46745a386
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    network-2.6.2.1-602ee4a12c5a174f6683a75303a065d3
    network-uri-2.6.0.3-27316eb865f3b3562ae77903534d67a4
    parsec-3.1.9-e73195cf6af19ee9d1587f67fa792c42
    time-1.5.0.1-cf94b0d806e26f6c4e356671290061b2
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
