#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 1.16.0.2
id: pandoc-1.16.0.2-1e3210a759893e8cb19c047605eb93fb
key: pando_CjYCh4RyfaKKGclRmtuBwD
license: GPL
copyright: (c) 2006-2015 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook,
    MediaWiki markup, TWiki markup, Haddock markup, OPML,
    Emacs Org-Mode, txt2tags, Word Docx, ODT, and Textile, and
    it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, OPML, OpenDocument, ODT,
    Word docx, RTF, MediaWiki, DokuWiki, Textile, groff man
    pages, plain text, Emacs Org-Mode, AsciiDoc, Haddock markup,
    EPUB (v2 and v3), FictionBook2, InDesign ICML, and several
    kinds of HTML/javascript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.Options Text.Pandoc.Pretty
    Text.Pandoc.Shared Text.Pandoc.MediaBag Text.Pandoc.Error
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.TeXMath
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.EPUB
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.PDF Text.Pandoc.UTF8
    Text.Pandoc.Templates Text.Pandoc.XML Text.Pandoc.SelfContained
    Text.Pandoc.Process Text.Pandoc.CSS
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Reducible Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Fonts Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Odt.Base
                Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils Text.Pandoc.Writers.Shared
                Text.Pandoc.Asciify Text.Pandoc.MIME Text.Pandoc.Emoji
                Text.Pandoc.Parsing Text.Pandoc.UUID Text.Pandoc.ImageSize
                Text.Pandoc.Slides Text.Pandoc.Highlighting Text.Pandoc.Compat.Time
                Text.Pandoc.Compat.Except Text.Pandoc.Compat.TagSoupEntity
                Text.Pandoc.Compat.Directory Text.Pandoc.Compat.Monoid Paths_pandoc
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/pandoc-1.16.0.2
library-dirs: /usr/lib/ghc-7.10.3/site-local/pandoc-1.16.0.2
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-1.16.0.2-CjYCh4RyfaKKGclRmtuBwD
depends:
    HTTP-4000.3.3-7109897251a899dcae4c73aced404403
    JuicyPixels-3.2.7-7a5ea2c8822f98f6d9837c143b0f3055
    SHA-1.6.4.2-532d5f478144692bd18b7bfd3a13e191
    aeson-0.11.1.1-0413068b3d94ca1008e286bfe7fa084f
    array-0.5.1.0-a4b4f31b03b7779670557ea46745a386
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    base64-bytestring-1.0.0.1-7819850819049320f81b6417431cc8a5
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    blaze-html-0.8.1.1-59ea4b5f01886f370857b4d16361c2fc
    blaze-markup-0.7.0.3-4e4a97653c712eed9984271000636729
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    cmark-0.5.1-28550a213c384aabe08ba531c632e415
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    data-default-0.5.3-a34fab0e414a3e31b9dccb1774520fca
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    directory-1.2.2.0-17b2023f9d7e8036d19e6b52b4f75c98
    extensible-exceptions-0.1.1.4-8159918b63d70675389129eaecbf720a
    filemanip-0.3.6.3-6a0a490bedb1f674368cb208047d68cb
    filepath-1.4.0.0-73e0bec80594160bf6dd6cb25217c6bf
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    haddock-library-1.2.1-51a4bfa148b95520f3c56461f9e3c4f2
    highlighting-kate-0.6.1-6cb702a677c14ceb9093e938f2884612
    hslua-0.4.1-5acb63b51e4a9d39e9aa4a0ad9006234
    http-client-0.4.27-649349307b7fbc2da7ba4e3fdfb27d3d
    http-client-tls-0.2.2-f98f7df0478363eb3e20cd852c79aa5a
    http-types-0.9-d392878af9c5e1b1993961dc71a9e177
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    network-2.6.2.1-602ee4a12c5a174f6683a75303a065d3
    network-uri-2.6.0.3-27316eb865f3b3562ae77903534d67a4
    old-time-1.1.0.3-91625432bd7c61d043f9b743fb82dcf7
    pandoc-types-1.16.1-4cd1533070797f7596c108f3982c26c4
    parsec-3.1.9-e73195cf6af19ee9d1587f67fa792c42
    process-1.2.3.0-21d25f1d78aeea6e68f1c768841f9794
    random-1.1-41a0a7ecd483c665a5c3a093a5be2968
    scientific-0.3.4.6-460bb668ffbf15e21b1a22bd826e372c
    syb-0.6-56a5944f55f7a9d47e7b770375c0e1ae
    tagsoup-0.13.8-ae67a6a9bc7b71798dd8f975b70085f0
    temporary-1.2.0.4-82bc44ff7d47fd2873d477b044a2a6ac
    texmath-0.8.4.2-d95aec46ca55bfe78645f4742c3c4ff8
    text-1.2.2.0-2f82ea4adfdd656d9a8840ad2ee17cc0
    time-1.5.0.1-cf94b0d806e26f6c4e356671290061b2
    unordered-containers-0.2.7.0-03f1d2fb96e30aca19bb1467e9476c22
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
    xml-1.3.14-47d6d03c8a900e03cf8951206101564b
    yaml-0.8.16-dde1f04caad6e58716b323c82d57d5b4
    zip-archive-0.2.3.7-dd493ec9051db44e1b98a11674551a0e
    zlib-0.6.1.1-863f5ed4c9ef7e591295c362d5c5d2a5
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
