#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tasty-rerun
version: 1.1.5
id: tasty-rerun-1.1.5-eff3ef7b439496facd7a6abb999fe270
key: tasty_4q7ELNoZU7E1y3FNCU3Wp1
license: BSD3
copyright: Oliver Charles (c) 2014
maintainer: ollie@ocharles.org.uk
homepage: http://github.com/ocharles/tasty-rerun
synopsis: Run tests by filtering the test tree depending on the result of previous test
          runs
description:
    This ingredient adds the ability to run tests by first filtering the test tree
    based on the result of a previous test run. For example, you can use this to
    run only those tests that failed in the last run, or to run only tests that
    have been added since tests were last ran.
    .
    This ingredient is specifically an ingredient *transformer* - given a list of
    '\''Tasty.Ingredient'\''s, '\''rerunningTests'\'' adds the ability for all of these
    ingredients to run against a filtered test tree. This transformer can be
    applied as follows:
    .
    > import Test.Tasty
    > import Test.Tasty.Runners
    >
    > main :: IO ()
    > main =
    >   defaultMainWithIngredients
    >     [ rerunningTests [ listingTests, consoleTestReporter ] ]
    >     tests
    >
    > tests :: TestTree
    > tests = undefined
    .
    This ingredient adds three command line parameters:
    .
    [@--rerun-update@] If specified the results of this test run will be saved to
    the log file at @--rerun-log-file@. If the ingredient does not execute tests
    (for example, @--list-tests@ is used) then the log file will not be
    updated. This option is not enabled by default.  This option does not require
    a value.
    .
    [@--rerun-log-file@] The path to the log file to read previous test
    information from, and where to write new information to (if @--rerun-update@
    is specified). This option defaults to @.tasty-rerun-log@.
    .
    [@--rerun-filter@] Which filters to apply to the '\''Tasty.TestTree'\'' based on
    previous test runs. The value of this option is a comma separated list of the
    following options:
    .
    * @failures@: Only run tests that failed on the previous run.
    .
    * @exceptions@: Only run tests that threw an exception on the previous run.
    .
    * @new@: Only run tests that are new since the previous test run.
    .
    * @successful@: Only run tests that were successful in the previous run.
    .
    Multiple options can be combined and will be taken under disjunction - so
    @--rerun-filter=failures,exceptions@ will run only tests that failed *or*
    threw an exception on the last run.
    .
    Defaults to all filters, which means all tests will be ran.
category: Testing
author: Oliver Charles
exposed: True
exposed-modules:
    Test.Tasty.Ingredients.Rerun
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/tasty-rerun-1.1.5
library-dirs: /usr/lib/ghc-7.10.3/site-local/tasty-rerun-1.1.5
data-dir: /usr/share/arm-linux-ghc-7.10.3/tasty-rerun-1.1.5
hs-libraries: HStasty-rerun-1.1.5-4q7ELNoZU7E1y3FNCU3Wp1
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    optparse-applicative-0.12.1.0-efdb53d7ee5eb339e181252750b5ba21
    reducers-3.12.1-9c0679f8e3a7104b42907174b9bc86fd
    split-0.2.3-1755fd7a4bff52537a62f0056f73dfbc
    stm-2.4.4.1-b43e402fc74ce6b0320fe4217e7e432d
    tagged-0.8.3-aa128de4449752177a05765fb0ce3959
    tasty-0.11.0.2-0e8cc58a9bca8b9b08149143caacc677
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
haddock-interfaces: /usr/share/doc/haskell-tasty-rerun/html/tasty-rerun.haddock
haddock-html: /usr/share/doc/haskell-tasty-rerun/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
