/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Connection;
import org.jmol.viewer.Viewer;

class Connections {
    protected String saveName;
    protected int bondCount;
    protected Connection[] connections;
    private Viewer vwr;

    protected Connections(Viewer viewer) {
        ModelSet modelSet = viewer.ms;
        if (modelSet == null) {
            return;
        }
        this.vwr = viewer;
        this.bondCount = modelSet.bondCount;
        this.connections = new Connection[this.bondCount + 1];
        Bond[] bondArray = modelSet.bo;
        int n = this.bondCount;
        while (--n >= 0) {
            Bond bond = bondArray[n];
            this.connections[n] = new Connection(bond.atom1.i, bond.atom2.i, bond.mad, bond.colix, bond.order, bond.getEnergy(), bond.shapeVisibilityFlags);
        }
    }

    protected boolean restore() {
        ModelSet modelSet = this.vwr.ms;
        if (modelSet == null) {
            return false;
        }
        modelSet.deleteAllBonds();
        int n = this.bondCount;
        while (--n >= 0) {
            Connection connection = this.connections[n];
            int n2 = modelSet.ac;
            if (connection.atomIndex1 >= n2 || connection.atomIndex2 >= n2) continue;
            Bond bond = modelSet.bondAtoms(modelSet.at[connection.atomIndex1], modelSet.at[connection.atomIndex2], connection.order, connection.mad, null, connection.energy, false, true);
            bond.colix = connection.colix;
            bond.shapeVisibilityFlags = connection.shapeVisibilityFlags;
        }
        n = this.bondCount;
        while (--n >= 0) {
            modelSet.bo[n].index = n;
        }
        this.vwr.setShapeProperty(1, "reportAll", null);
        return true;
    }
}

