/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.datatransfer.PrimitiveTransferable;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.ListPopupMenu;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class SelectionListDialog
extends ToggleDialog {
    private JList<OsmPrimitive> lstPrimitives;
    private final DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private final SelectionListModel model = new SelectionListModel(this.selectionModel);
    private final SelectAction actSelect = new SelectAction();
    private final SearchAction actSearch = new SearchAction();
    private final ShowHistoryAction actShowHistory = new ShowHistoryAction();
    private final ZoomToJOSMSelectionAction actZoomToJOSMSelection = new ZoomToJOSMSelectionAction();
    private final ZoomToListSelection actZoomToListSelection = new ZoomToListSelection();
    private final SelectInRelationListAction actSetRelationSelection = new SelectInRelationListAction();
    private final EditRelationAction actEditRelationSelection = new EditRelationAction();
    private final DownloadSelectedIncompleteMembersAction actDownloadSelIncompleteMembers = new DownloadSelectedIncompleteMembersAction();
    private final ListPopupMenu popupMenu;
    private final transient PopupMenuHandler popupMenuHandler;

    protected void buildContentPanel() {
        this.lstPrimitives = new JList<OsmPrimitive>(this.model);
        this.lstPrimitives.setSelectionMode(2);
        this.lstPrimitives.setSelectionModel(this.selectionModel);
        this.lstPrimitives.setCellRenderer(new OsmPrimitivRenderer());
        this.lstPrimitives.setTransferHandler(new SelectionTransferHandler());
        if (!GraphicsEnvironment.isHeadless()) {
            this.lstPrimitives.setDragEnabled(true);
        }
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actSelect);
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actShowHistory);
        final SideButton sideButton = new SideButton(this.actSelect);
        sideButton.createArrow(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectionHistoryPopup.launch(sideButton, SelectionListDialog.this.model.getSelectionHistory());
            }
        });
        final SideButton sideButton2 = new SideButton(this.actSearch);
        sideButton2.createArrow(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPopupMenu.launch(sideButton2);
            }
        });
        this.createLayout(this.lstPrimitives, true, Arrays.asList(sideButton, sideButton2, new SideButton(this.actShowHistory)));
    }

    public SelectionListDialog() {
        super(I18n.tr("Selection", new Object[0]), "selectionlist", I18n.tr("Open a selection list window.", new Object[0]), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection", new Object[0])), 84, 5007), 150, true);
        this.buildContentPanel();
        this.model.addListDataListener(new TitleUpdater());
        this.model.addListDataListener(this.actZoomToJOSMSelection);
        this.popupMenu = new ListPopupMenu(this.lstPrimitives);
        this.popupMenuHandler = this.setupPopupMenuHandler();
        this.lstPrimitives.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SelectionListDialog.this.actZoomToListSelection.valueChanged(listSelectionEvent);
                SelectionListDialog.this.popupMenuHandler.setPrimitives(SelectionListDialog.this.model.getSelected());
            }
        });
        this.lstPrimitives.addMouseListener(new MouseEventHandler());
        InputMapUtils.addEnterAction(this.lstPrimitives, this.actZoomToListSelection);
    }

    @Override
    public void showNotify() {
        MapView.addEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().addSelectionListener(this.actShowHistory, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this.model, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        DatasetEventManager.getInstance().addDatasetListener(this.model, DatasetEventManager.FireMode.IN_EDT);
        MapView.addEditLayerChangeListener(this.actSearch);
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        this.model.editLayerChanged(null, osmDataLayer);
        if (osmDataLayer != null) {
            this.model.setJOSMSelection(osmDataLayer.data.getAllSelected());
        }
        this.actSearch.updateEnabledState();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this.actSearch);
        MapView.removeEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().removeSelectionListener(this.actShowHistory);
        SelectionEventManager.getInstance().removeSelectionListener(this.model);
        DatasetEventManager.getInstance().removeDatasetListener(this.model);
    }

    private PopupMenuHandler setupPopupMenuHandler() {
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
        popupMenuHandler.addAction(this.actZoomToJOSMSelection);
        popupMenuHandler.addAction(this.actZoomToListSelection);
        popupMenuHandler.addSeparator();
        popupMenuHandler.addAction(this.actSetRelationSelection);
        popupMenuHandler.addAction(this.actEditRelationSelection);
        popupMenuHandler.addSeparator();
        popupMenuHandler.addAction(this.actDownloadSelIncompleteMembers);
        return popupMenuHandler;
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public Collection<OsmPrimitive> getSelectedPrimitives() {
        return this.model.getSelected();
    }

    protected class SelectionTransferHandler
    extends TransferHandler {
        protected SelectionTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return new PrimitiveTransferable(SelectionListDialog.this.getSelectedPrimitives());
        }
    }

    protected static class SelectionHistoryPopup
    extends JPopupMenu {
        public static void launch(Component component, Collection<Collection<? extends OsmPrimitive>> collection) {
            if (collection == null || collection.isEmpty()) {
                return;
            }
            SelectionHistoryPopup selectionHistoryPopup = new SelectionHistoryPopup(collection);
            Rectangle rectangle = component.getBounds();
            selectionHistoryPopup.show(component, rectangle.x, rectangle.y + rectangle.height);
        }

        public SelectionHistoryPopup(Collection<Collection<? extends OsmPrimitive>> collection) {
            for (Collection<? extends OsmPrimitive> collection2 : collection) {
                this.add(new SelectionMenuItem(collection2));
            }
        }
    }

    protected static class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        protected transient Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> collection) {
            this.sel = collection;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive object2 : collection) {
                if (!object2.isSelectable()) continue;
                if (object2 instanceof Way) {
                    ++n;
                    continue;
                }
                if (object2 instanceof Node) {
                    ++n2;
                    continue;
                }
                if (!(object2 instanceof Relation)) continue;
                ++n3;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (n != 0) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(I18n.trn("{0} way", "{0} ways", n, n));
            }
            if (n2 != 0) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(I18n.trn("{0} node", "{0} nodes", n2, n2));
            }
            if (n3 != 0) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(I18n.trn("{0} relation", "{0} relations", n3, n3));
            }
            if (n + n2 + n3 == 0) {
                stringBuilder.append(I18n.tr("Unselectable now", new Object[0]));
                this.sel = new ArrayList<OsmPrimitive>();
            }
            DefaultNameFormatter defaultNameFormatter = DefaultNameFormatter.getInstance();
            if (n + n2 + n3 == 1) {
                stringBuilder.append(": ");
                for (OsmPrimitive osmPrimitive : collection) {
                    stringBuilder.append(osmPrimitive.getDisplayName(defaultNameFormatter));
                }
                this.setText(stringBuilder.toString());
            } else {
                this.setText(I18n.tr("Selection: {0}", stringBuilder));
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }

    protected static class SearchPopupMenu
    extends JPopupMenu {
        public static void launch(Component component) {
            if (org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory().isEmpty()) {
                return;
            }
            SearchPopupMenu searchPopupMenu = new SearchPopupMenu();
            Rectangle rectangle = component.getBounds();
            searchPopupMenu.show(component, rectangle.x, rectangle.y + rectangle.height);
        }

        public SearchPopupMenu() {
            for (SearchAction.SearchSetting searchSetting : org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory()) {
                this.add(new SearchMenuItem(searchSetting));
            }
        }
    }

    protected static class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected final transient SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting searchSetting) {
            super(Utils.shortenString(searchSetting.toString(), 100));
            this.s = searchSetting;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(this.s);
        }
    }

    private static class SelectionListModel
    extends AbstractListModel<OsmPrimitive>
    implements MapView.EditLayerChangeListener,
    SelectionChangedListener,
    DataSetListener {
        private static final int SELECTION_HISTORY_SIZE = 10;
        private LinkedList<Collection<? extends OsmPrimitive>> history;
        private final transient List<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        private final DefaultListSelectionModel selectionModel;

        SelectionListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public synchronized String getJOSMSelectionSummary() {
            if (this.selection.isEmpty()) {
                return I18n.tr("Selection", new Object[0]);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive osmPrimitive : this.selection) {
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        ++n;
                        break;
                    }
                    case WAY: {
                        ++n2;
                        break;
                    }
                    case RELATION: {
                        ++n3;
                    }
                }
            }
            return I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", n3, n2, n);
        }

        public void remember(Collection<? extends OsmPrimitive> collection) {
            int n;
            if (collection == null) {
                return;
            }
            if (collection.isEmpty()) {
                return;
            }
            if (this.history == null) {
                return;
            }
            if (this.history.isEmpty()) {
                this.history.add(collection);
                return;
            }
            if (this.history.getFirst().equals(collection)) {
                return;
            }
            this.history.addFirst(collection);
            for (n = 1; n < this.history.size(); ++n) {
                if (!this.history.get(n).equals(collection)) continue;
                this.history.remove(n);
                break;
            }
            n = Main.pref.getInteger("select.history-size", 10);
            while (this.history.size() > n) {
                this.history.removeLast();
            }
        }

        public List<Collection<? extends OsmPrimitive>> getSelectionHistory() {
            return this.history;
        }

        @Override
        public synchronized OsmPrimitive getElementAt(int n) {
            return this.selection.get(n);
        }

        @Override
        public synchronized int getSize() {
            return this.selection.size();
        }

        public synchronized Collection<OsmPrimitive> getSelected() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                hashSet.add(this.selection.get(i));
            }
            return hashSet;
        }

        public synchronized void setSelected(Collection<OsmPrimitive> collection) {
            this.selectionModel.clearSelection();
            if (collection == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.selection.indexOf(osmPrimitive);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        @Override
        protected void fireContentsChanged(Object object, int n, int n2) {
            Collection<OsmPrimitive> collection = this.getSelected();
            super.fireContentsChanged(object, n, n2);
            this.setSelected(collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setJOSMSelection(final Collection<? extends OsmPrimitive> collection) {
            SelectionListModel selectionListModel = this;
            synchronized (selectionListModel) {
                this.selection.clear();
                if (collection != null) {
                    this.selection.addAll(collection);
                    this.sort();
                }
            }
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    SelectionListModel.this.fireContentsChanged(this, 0, SelectionListModel.this.getSize());
                    if (collection != null) {
                        SelectionListModel.this.remember(collection);
                        if (collection.size() == 2) {
                            Iterator iterator = collection.iterator();
                            OsmPrimitive osmPrimitive = (OsmPrimitive)iterator.next();
                            OsmPrimitive osmPrimitive2 = (OsmPrimitive)iterator.next();
                            if (osmPrimitive instanceof Node && osmPrimitive2 instanceof Node) {
                                LatLon latLon = ((Node)osmPrimitive).getCoor();
                                LatLon latLon2 = ((Node)osmPrimitive2).getCoor();
                                if (latLon != null && latLon2 != null) {
                                    Main.map.statusLine.setDist(latLon.greatCircleDistance(latLon2));
                                    return;
                                }
                            }
                        }
                        Main.map.statusLine.setDist(new SubclassFilteredCollection(collection, OsmPrimitive.wayPredicate));
                    }
                }
            });
        }

        public synchronized void update(Collection<? extends OsmPrimitive> collection) {
            if (collection == null) {
                return;
            }
            if (collection.isEmpty()) {
                return;
            }
            Collection<OsmPrimitive> collection2 = this.getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.selection.indexOf(osmPrimitive);
                if (n < 0) continue;
                super.fireContentsChanged(this, n, n);
            }
            this.setSelected(collection2);
        }

        public synchronized void sort() {
            if (this.selection.size() <= Main.pref.getInteger("selection.no_sort_above", 100000)) {
                boolean bl = this.selection.size() > Main.pref.getInteger("selection.fast_sort_above", 10000);
                Collections.sort(this.selection, new OsmPrimitiveComparator(bl, false));
            }
        }

        @Override
        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            if (osmDataLayer2 == null) {
                this.setJOSMSelection(null);
                this.history = null;
            } else {
                this.history = osmDataLayer2.data.getSelectionHistory();
                this.setJOSMSelection(osmDataLayer2.data.getAllSelected());
            }
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.setJOSMSelection(collection);
        }

        @Override
        public void dataChanged(DataChangedEvent dataChangedEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
            this.update(nodeMovedEvent.getPrimitives());
        }

        @Override
        public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
            this.update(abstractDatasetChangedEvent.getPrimitives());
        }

        @Override
        public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
            this.update(relationMembersChangedEvent.getPrimitives());
        }

        @Override
        public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
            this.update(tagsChangedEvent.getPrimitives());
        }

        @Override
        public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
            this.update(wayNodesChangedEvent.getPrimitives());
        }

        @Override
        public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        }

        @Override
        public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        }
    }

    class ZoomToListSelection
    extends AbstractAction
    implements ListSelectionListener {
        ZoomToListSelection() {
            this.putValue("Name", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty()) {
                return;
            }
            boundingXYVisitor.computeBoundingBox(collection);
            if (boundingXYVisitor.getBounds() == null) {
                return;
            }
            boundingXYVisitor.enlargeBoundingBox();
            Main.map.mapView.zoomTo(boundingXYVisitor);
        }

        protected void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ZoomToJOSMSelectionAction
    extends AbstractAction
    implements ListDataListener {
        ZoomToJOSMSelectionAction() {
            this.putValue("Name", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AutoScaleAction.autoScale("selection");
        }

        public void updateEnabledState() {
            this.setEnabled(SelectionListDialog.this.model.getSize() > 0);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener,
    SelectionChangedListener {
        ShowHistoryAction() {
            this.putValue("Name", I18n.tr("History", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Display the history of the selected objects.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.updateEnabledState(SelectionListDialog.this.model.getSize());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty() && SelectionListDialog.this.model.getSize() != 1) {
                return;
            }
            if (collection.isEmpty()) {
                collection = Collections.singleton(SelectionListDialog.this.model.getElementAt(0));
            }
            HistoryBrowserDialogManager.getInstance().showHistory(collection);
        }

        protected void updateEnabledState(int n) {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty() || n == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState(SelectionListDialog.this.model.getSize());
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.updateEnabledState(collection.size());
        }
    }

    class SelectAction
    extends AbstractSelectAction
    implements ListSelectionListener {
        SelectAction() {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty()) {
                return;
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            osmDataLayer.data.setSelected(collection);
            SelectionListDialog.this.model.selectionModel.setSelectionInterval(0, collection.size() - 1);
        }

        protected void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class SearchAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        SearchAction() {
            this.putValue("Name", I18n.tr("Search", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Search for objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            org.openstreetmap.josm.actions.search.SearchAction.search();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.hasEditLayer());
        }

        @Override
        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            this.updateEnabledState();
        }
    }

    class TitleUpdater
    implements ListDataListener {
        TitleUpdater() {
        }

        protected void updateTitle() {
            SelectionListDialog.this.setTitle(SelectionListDialog.this.model.getJOSMSelectionSummary());
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.updateTitle();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.updateTitle();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.updateTitle();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        private final HighlightHelper helper;
        private final boolean highlightEnabled;

        MouseEventHandler() {
            super(SelectionListDialog.this.popupMenu);
            this.helper = new HighlightHelper();
            this.highlightEnabled = Main.pref.getBoolean("draw.target-highlight", true);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = SelectionListDialog.this.lstPrimitives.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            if (MouseEventHandler.isDoubleClick(mouseEvent)) {
                OsmDataLayer osmDataLayer = Main.main.getEditLayer();
                if (osmDataLayer == null) {
                    return;
                }
                OsmPrimitive osmPrimitive = SelectionListDialog.this.model.getElementAt(n);
                Collection<OsmPrimitive> collection = osmDataLayer.data.getSelected();
                if (collection.size() != 1 || !collection.iterator().next().equals(osmPrimitive)) {
                    osmDataLayer.data.setSelected(Collections.singleton(osmPrimitive));
                } else if (osmPrimitive instanceof Relation) {
                    SelectionListDialog.this.actEditRelationSelection.actionPerformed(null);
                }
            } else if (this.highlightEnabled && Main.isDisplayingMapView() && this.helper.highlightOnly(SelectionListDialog.this.model.getElementAt(n))) {
                Main.map.mapView.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.highlightEnabled) {
                this.helper.clear();
            }
            super.mouseExited(mouseEvent);
        }
    }
}

