/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultAssumption;
import com.oracle.truffle.api.impl.DefaultCallTarget;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.impl.DefaultDirectCallNode;
import com.oracle.truffle.api.impl.DefaultIndirectCallNode;
import com.oracle.truffle.api.impl.DefaultLoopNode;
import com.oracle.truffle.api.impl.DefaultMaterializedFrame;
import com.oracle.truffle.api.impl.DefaultVirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public final class DefaultTruffleRuntime
implements TruffleRuntime {
    private final ThreadLocal<LinkedList<FrameInstance>> stackTraces = new ThreadLocal();
    private final ThreadLocal<FrameInstance> currentFrames = new ThreadLocal();
    private final Map<RootCallTarget, Void> callTargets = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public String getName() {
        return "Default Truffle Runtime";
    }

    @Override
    public RootCallTarget createCallTarget(RootNode rootNode) {
        DefaultCallTarget target = new DefaultCallTarget(rootNode);
        rootNode.setCallTarget(target);
        this.callTargets.put(target, null);
        return target;
    }

    @Override
    public DirectCallNode createDirectCallNode(CallTarget target) {
        return new DefaultDirectCallNode(target);
    }

    @Override
    public IndirectCallNode createIndirectCallNode() {
        return new DefaultIndirectCallNode();
    }

    @Override
    public VirtualFrame createVirtualFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new DefaultVirtualFrame(frameDescriptor, arguments);
    }

    @Override
    public MaterializedFrame createMaterializedFrame(Object[] arguments) {
        return this.createMaterializedFrame(arguments, new FrameDescriptor());
    }

    @Override
    public MaterializedFrame createMaterializedFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new DefaultMaterializedFrame(new DefaultVirtualFrame(frameDescriptor, arguments));
    }

    @Override
    public CompilerOptions createCompilerOptions() {
        return new DefaultCompilerOptions();
    }

    @Override
    public Assumption createAssumption() {
        return this.createAssumption(null);
    }

    @Override
    public Assumption createAssumption(String name) {
        return new DefaultAssumption(name);
    }

    private LinkedList<FrameInstance> getThreadLocalStackTrace() {
        LinkedList<FrameInstance> result = this.stackTraces.get();
        if (result == null) {
            result = new LinkedList();
            this.stackTraces.set(result);
        }
        return result;
    }

    public FrameInstance setCurrentFrame(FrameInstance newValue) {
        FrameInstance oldValue = this.currentFrames.get();
        this.currentFrames.set(newValue);
        return oldValue;
    }

    public void pushFrame(FrameInstance frame) {
        this.getThreadLocalStackTrace().addFirst(frame);
    }

    public void popFrame() {
        this.getThreadLocalStackTrace().removeFirst();
    }

    @Override
    public <T> T iterateFrames(FrameInstanceVisitor<T> visitor) {
        T result = null;
        for (FrameInstance frameInstance : this.getThreadLocalStackTrace()) {
            result = visitor.visitFrame(frameInstance);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public FrameInstance getCallerFrame() {
        return this.getThreadLocalStackTrace().peekFirst();
    }

    @Override
    public Collection<RootCallTarget> getCallTargets() {
        return Collections.unmodifiableSet(this.callTargets.keySet());
    }

    @Override
    public FrameInstance getCurrentFrame() {
        return this.currentFrames.get();
    }

    @Override
    public <T> T getCapability(Class<T> capability) {
        return null;
    }

    @Override
    public void notifyTransferToInterpreter() {
    }

    @Override
    public LoopNode createLoopNode(RepeatingNode repeating) {
        if (!(repeating instanceof Node)) {
            throw new IllegalArgumentException("Repeating node must be of type Node.");
        }
        return new DefaultLoopNode(repeating);
    }

    @Override
    public boolean isProfilingEnabled() {
        return false;
    }
}

