/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.output;

import java.io.IOException;
import java.io.OutputStream;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;

public class StreamTaskOutput
implements MultipleTaskOutput<OutputStream>,
SingleTaskOutput<OutputStream> {
    @NotNull
    private final OutputStream stream;

    public StreamTaskOutput(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("A not null stream instance is expected.");
        }
        this.stream = stream;
    }

    @Override
    public OutputStream getDestination() {
        return this.stream;
    }

    @Override
    public void accept(TaskOutputDispatcher writer) throws TaskOutputVisitException {
        try {
            writer.dispatch(this);
        }
        catch (IOException e) {
            throw new TaskOutputVisitException("Exception dispatching the stream task output.", e);
        }
    }

    public String toString() {
        return new ToStringBuilder(this).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.stream).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StreamTaskOutput)) {
            return false;
        }
        StreamTaskOutput output = (StreamTaskOutput)other;
        return new EqualsBuilder().append(this.stream, output.getDestination()).isEquals();
    }
}

