/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.form;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroupAttributes;
import org.sejda.sambox.util.Matrix;

public class PDFormXObject
extends PDXObject
implements PDContentStream {
    private PDTransparencyGroupAttributes group;
    private final ResourceCache cache;

    public PDFormXObject(PDStream stream) {
        super(stream, COSName.FORM);
        this.cache = null;
    }

    public PDFormXObject(COSStream stream) {
        super(stream, COSName.FORM);
        this.cache = null;
    }

    public PDFormXObject(COSStream stream, ResourceCache cache) {
        super(stream, COSName.FORM);
        this.cache = cache;
    }

    public PDFormXObject() {
        super(COSName.FORM);
        this.cache = null;
    }

    public int getFormType() {
        return this.getCOSStream().getInt(COSName.FORMTYPE, 1);
    }

    public void setFormType(int formType) {
        this.getCOSStream().setInt(COSName.FORMTYPE, formType);
    }

    public PDTransparencyGroupAttributes getGroup() {
        COSDictionary dic;
        if (this.group == null && (dic = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.GROUP)) != null) {
            this.group = new PDTransparencyGroupAttributes(dic);
        }
        return this.group;
    }

    public PDStream getContentStream() {
        return new PDStream(this.getCOSStream());
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.getCOSStream().getUnfilteredStream();
    }

    @Override
    public PDResources getResources() {
        COSDictionary resources = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            return new PDResources(resources, this.cache);
        }
        return null;
    }

    public void setResources(PDResources resources) {
        this.getCOSStream().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSStream().removeItem(COSName.BBOX);
        } else {
            this.getCOSStream().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }

    @Override
    public Matrix getMatrix() {
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            return new Matrix(array);
        }
        return new Matrix();
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSStream().setItem(COSName.MATRIX, (COSBase)matrix);
    }

    public int getStructParents() {
        return this.getCOSStream().getInt(COSName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParent) {
        this.getCOSStream().setInt(COSName.STRUCT_PARENTS, structParent);
    }
}

