/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Vector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.parosproxy.paros.core.scanner.Kb;

public class KbUnitTest {
    private static final String TEST_KEY = "key";
    private static final String ANOTHER_KEY = "otherKey";
    private static final Object TEST_OBJECT_1 = new Object();
    private static final Object TEST_OBJECT_2 = new Object();
    private static final Boolean TEST_BOOLEAN = Boolean.TRUE;
    private static final String TEST_STRING = "Test";
    Kb knowledgeBase;

    @Before
    public void setUp() throws Exception {
        this.knowledgeBase = new Kb();
    }

    @Test
    public void shouldStoreValueForGivenKey() {
        this.knowledgeBase.add(TEST_KEY, TEST_OBJECT_1);
        Assert.assertThat((Object)this.knowledgeBase.get(TEST_KEY), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_OBJECT_1)));
    }

    @Test
    @Ignore
    public void shouldStoreValueForGivenUriAndKey() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void shouldRetrieveStoredObjectsForGivenKey() {
        this.knowledgeBase.add(TEST_KEY, TEST_OBJECT_1);
        this.knowledgeBase.add(TEST_KEY, TEST_OBJECT_2);
        Vector<Object> vector = this.knowledgeBase.getList(TEST_KEY);
        Assert.assertThat(vector, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(vector, (Matcher)Matchers.contains((Object[])new Object[]{TEST_OBJECT_1, TEST_OBJECT_2}));
    }

    @Test
    @Ignore
    public void shouldRetrieveStoredObjectsForGivenUriAndKey() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void shouldRetrieveStoredBooleanForGivenKey() {
        this.knowledgeBase.add(TEST_KEY, TEST_BOOLEAN);
        Assert.assertThat((Object)this.knowledgeBase.getBoolean(TEST_KEY), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_BOOLEAN)));
    }

    @Test
    @Ignore
    public void shouldRetrieveStoredBooleanForGivenUriAndKey() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void shouldRetrieveStoredStringForGivenKey() {
        this.knowledgeBase.add(TEST_KEY, TEST_STRING);
        Assert.assertThat((Object)this.knowledgeBase.getString(TEST_KEY), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_STRING)));
    }

    @Test
    @Ignore
    public void shouldRetrieveStoredStringForGivenUriAndKey() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void shouldReturnNullWhenGivenKeyHasNoStoredValue() {
        this.knowledgeBase.add(TEST_KEY, TEST_OBJECT_1);
        Assert.assertThat((Object)this.knowledgeBase.get(ANOTHER_KEY), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldReturnFalseWhenRetrievingNonBooleanValueAsBoolean() {
        this.knowledgeBase.add(TEST_KEY, TEST_OBJECT_1);
        Assert.assertThat((Object)this.knowledgeBase.getBoolean(TEST_KEY), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldReturnNullWhenRetrievingNonStringValueAsString() {
        this.knowledgeBase.add(TEST_KEY, TEST_OBJECT_1);
        Assert.assertThat((Object)this.knowledgeBase.getString(TEST_KEY), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

