/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.UnparseableExtension;

public class CertificateExtensions
implements CertAttrSet<Extension> {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private static final Debug debug = Debug.getInstance("x509");
    private Map<String, Extension> map = Collections.synchronizedMap(new TreeMap());
    private boolean unsupportedCritExt = false;
    private Map<String, Extension> unparseableExtensions;
    private static Class[] PARAMS = new Class[]{Boolean.class, Object.class};

    public CertificateExtensions() {
    }

    public CertificateExtensions(DerInputStream in) throws IOException {
        this.init(in);
    }

    private void init(DerInputStream in) throws IOException {
        DerValue[] exts = in.getSequence(5);
        for (int i = 0; i < exts.length; ++i) {
            Extension ext = new Extension(exts[i]);
            this.parseExtension(ext);
        }
    }

    private void parseExtension(Extension ext) throws IOException {
        try {
            Class extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass == null) {
                if (ext.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(ext.getExtensionId().toString(), ext) == null) {
                    return;
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            Constructor cons = extClass.getConstructor(PARAMS);
            Object[] passed = new Object[]{ext.isCritical(), ext.getExtensionValue()};
            CertAttrSet certExt = (CertAttrSet)cons.newInstance(passed);
            if (this.map.put(certExt.getName(), (Extension)((Object)certExt)) != null) {
                throw new IOException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invk) {
            Throwable e = invk.getTargetException();
            if (!ext.isCritical()) {
                if (this.unparseableExtensions == null) {
                    this.unparseableExtensions = new TreeMap<String, Extension>();
                }
                this.unparseableExtensions.put(ext.getExtensionId().toString(), new UnparseableExtension(ext, e));
                if (debug != null) {
                    debug.println("Error parsing extension: " + ext);
                    e.printStackTrace();
                    HexDumpEncoder h = new HexDumpEncoder();
                    System.err.println(h.encodeBuffer(ext.getExtensionValue()));
                }
                return;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        this.encode(out, false);
    }

    public void encode(OutputStream out, boolean isCertReq) throws CertificateException, IOException {
        DerOutputStream tmp;
        DerOutputStream extOut = new DerOutputStream();
        Collection<Extension> allExts = this.map.values();
        Object[] objs = allExts.toArray();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] instanceof CertAttrSet) {
                ((CertAttrSet)objs[i]).encode(extOut);
                continue;
            }
            if (objs[i] instanceof Extension) {
                ((Extension)objs[i]).encode(extOut);
                continue;
            }
            throw new CertificateException("Illegal extension object");
        }
        DerOutputStream seq = new DerOutputStream();
        seq.write((byte)48, extOut);
        if (!isCertReq) {
            tmp = new DerOutputStream();
            tmp.write(DerValue.createTag((byte)-128, true, (byte)3), seq);
        } else {
            tmp = seq;
        }
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Extension)) {
            throw new IOException("Unknown extension type.");
        }
        this.map.put(name, (Extension)obj);
    }

    @Override
    public Object get(String name) throws IOException {
        Extension obj = this.map.get(name);
        if (obj == null) {
            throw new IOException("No extension found with name " + name);
        }
        return obj;
    }

    Extension getExtension(String name) {
        return this.map.get(name);
    }

    @Override
    public void delete(String name) throws IOException {
        Extension obj = this.map.get(name);
        if (obj == null) {
            throw new IOException("No extension found with name " + name);
        }
        this.map.remove(name);
    }

    public String getNameByOid(ObjectIdentifier oid) throws IOException {
        for (String name : this.map.keySet()) {
            if (!this.map.get(name).getExtensionId().equals(oid)) continue;
            return name;
        }
        return null;
    }

    @Override
    public Enumeration<Extension> getElements() {
        return Collections.enumeration(this.map.values());
    }

    public Collection<Extension> getAllExtensions() {
        return this.map.values();
    }

    public Map<String, Extension> getUnparseableExtensions() {
        if (this.unparseableExtensions == null) {
            return Collections.emptyMap();
        }
        return this.unparseableExtensions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CertificateExtensions)) {
            return false;
        }
        Collection<Extension> otherC = ((CertificateExtensions)other).getAllExtensions();
        Object[] objs = otherC.toArray();
        int len = objs.length;
        if (len != this.map.size()) {
            return false;
        }
        String key = null;
        for (int i = 0; i < len; ++i) {
            Extension thisExt;
            if (objs[i] instanceof CertAttrSet) {
                key = ((CertAttrSet)objs[i]).getName();
            }
            Extension otherExt = (Extension)objs[i];
            if (key == null) {
                key = otherExt.getExtensionId().toString();
            }
            if ((thisExt = this.map.get(key)) == null) {
                return false;
            }
            if (thisExt.equals(otherExt)) continue;
            return false;
        }
        return this.getUnparseableExtensions().equals(((CertificateExtensions)other).getUnparseableExtensions());
    }

    public int hashCode() {
        return this.map.hashCode() + this.getUnparseableExtensions().hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }
}

