/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BoostingQuery
extends Query {
    private final float boost;
    private final Query match;
    private final Query context;

    public BoostingQuery(Query match, Query context, float boost) {
        this.match = match;
        this.context = context;
        this.boost = boost;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query matchRewritten = this.match.rewrite(reader);
        Query contextRewritten = this.context.rewrite(reader);
        if (this.match != matchRewritten || this.context != contextRewritten) {
            return new BoostingQuery(matchRewritten, contextRewritten, this.boost);
        }
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!needsScores) {
            return this.match.createWeight(searcher, needsScores);
        }
        final Weight matchWeight = searcher.createWeight(this.match, needsScores);
        final Weight contextWeight = searcher.createWeight(this.context, false);
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
                matchWeight.extractTerms(terms);
                if (BoostingQuery.this.boost >= 1.0f) {
                    contextWeight.extractTerms(terms);
                }
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation matchExplanation = matchWeight.explain(context, doc);
                Explanation contextExplanation = contextWeight.explain(context, doc);
                if (!matchExplanation.isMatch() || !contextExplanation.isMatch()) {
                    return matchExplanation;
                }
                return Explanation.match((float)(matchExplanation.getValue() * BoostingQuery.this.boost), (String)"product of:", (Explanation[])new Explanation[]{matchExplanation, Explanation.match((float)BoostingQuery.this.boost, (String)"boost", (Explanation[])new Explanation[0])});
            }

            public float getValueForNormalization() throws IOException {
                return matchWeight.getValueForNormalization();
            }

            public void normalize(float norm, float boost) {
                matchWeight.normalize(norm, boost);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer matchScorer = matchWeight.scorer(context);
                if (matchScorer == null) {
                    return null;
                }
                Scorer contextScorer = contextWeight.scorer(context);
                if (contextScorer == null) {
                    return matchScorer;
                }
                TwoPhaseIterator contextTwoPhase = contextScorer.asTwoPhaseIterator();
                Scorer contextApproximation = contextTwoPhase == null ? contextScorer : contextTwoPhase.approximation();
                return new FilterScorer(matchScorer, (DocIdSetIterator)contextApproximation, contextTwoPhase){
                    final /* synthetic */ DocIdSetIterator val$contextApproximation;
                    final /* synthetic */ TwoPhaseIterator val$contextTwoPhase;
                    {
                        this.val$contextApproximation = docIdSetIterator;
                        this.val$contextTwoPhase = twoPhaseIterator;
                        super(x0);
                    }

                    public float score() throws IOException {
                        if (this.val$contextApproximation.docID() < this.docID()) {
                            this.val$contextApproximation.advance(this.docID());
                        }
                        assert (this.val$contextApproximation.docID() >= this.docID());
                        float score = super.score();
                        if (this.val$contextApproximation.docID() == this.docID() && (this.val$contextTwoPhase == null || this.val$contextTwoPhase.matches())) {
                            score *= BoostingQuery.this.boost;
                        }
                        return score;
                    }
                };
            }
        };
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.match, this.context, Float.valueOf(this.boost));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoostingQuery that = (BoostingQuery)((Object)obj);
        return this.match.equals((Object)that.match) && this.context.equals((Object)that.context) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(that.boost);
    }

    public String toString(String field) {
        return this.match.toString(field) + "/" + this.context.toString(field) + ToStringUtils.boost((float)this.getBoost());
    }
}

