/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.get;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetIndexedScriptAction
extends HandledTransportAction<GetIndexedScriptRequest, GetIndexedScriptResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportGetIndexedScriptAction(Settings settings, ThreadPool threadPool, ScriptService scriptService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/script/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetIndexedScriptRequest.class);
        this.scriptService = scriptService;
    }

    @Override
    public void doExecute(GetIndexedScriptRequest request, final ActionListener<GetIndexedScriptResponse> listener) {
        this.scriptService.queryScriptIndex(request, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse getFields) {
                listener.onResponse(new GetIndexedScriptResponse(getFields));
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }
}

