/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.logging.Loggers;

final class JVMCheck {
    static final String JVM_RECOMMENDATIONS = "http://www.elastic.co/guide/en/elasticsearch/reference/current/_installation.html";
    static final String JVM_BYPASS = "es.bypass.vm.check";
    static final Map<String, HotspotBug> JVM_BROKEN_HOTSPOT_VERSIONS;

    private JVMCheck() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void check() {
        if (Boolean.parseBoolean(System.getProperty(JVM_BYPASS))) {
            Loggers.getLogger(JVMCheck.class).warn("bypassing jvm version check for version [{}], this can result in data corruption!", JVMCheck.fullVersion());
            return;
        }
        if ("Oracle Corporation".equals(Constants.JVM_VENDOR)) {
            HotspotBug bug = JVM_BROKEN_HOTSPOT_VERSIONS.get(Constants.JVM_VERSION);
            if (bug == null) return;
            if (bug.workAround == null || !ManagementFactory.getRuntimeMXBean().getInputArguments().contains(bug.workAround)) throw new RuntimeException(bug.getErrorMessage());
            Loggers.getLogger(JVMCheck.class).warn(bug.getWarningMessage(), new Object[0]);
            return;
        }
        if (!"IBM Corporation".equals(Constants.JVM_VENDOR)) return;
        float version = Float.POSITIVE_INFINITY;
        try {
            version = Float.parseFloat(Constants.JVM_VERSION);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!(version < 2.8f)) return;
        StringBuilder sb = new StringBuilder();
        sb.append("IBM J9 runtimes < 2.8 suffer from several bugs which can cause data corruption.");
        sb.append(System.lineSeparator());
        sb.append("Your version: " + JVMCheck.fullVersion());
        sb.append(System.lineSeparator());
        sb.append("Please upgrade the JVM to a recent IBM JDK");
        throw new RuntimeException(sb.toString());
    }

    static String fullVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.JAVA_VENDOR);
        sb.append(" ");
        sb.append(Constants.JAVA_VERSION);
        sb.append(" [");
        sb.append(Constants.JVM_NAME);
        sb.append(" ");
        sb.append(Constants.JVM_VERSION);
        sb.append("]");
        return sb.toString();
    }

    static {
        HashMap<String, HotspotBug> bugs = new HashMap<String, HotspotBug>();
        bugs.put("21.0-b17", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-7070134", "-XX:-UseLoopPredicate"));
        bugs.put("24.0-b56", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-8024830", "-XX:-UseSuperWord"));
        bugs.put("24.45-b08", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-8024830", "-XX:-UseSuperWord"));
        bugs.put("24.51-b03", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-8024830", "-XX:-UseSuperWord"));
        JVM_BROKEN_HOTSPOT_VERSIONS = Collections.unmodifiableMap(bugs);
    }

    static final class HotspotBug {
        final String bugUrl;
        final String workAround;

        HotspotBug(String bugUrl, String workAround) {
            this.bugUrl = bugUrl;
            this.workAround = workAround;
        }

        String getErrorMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Java version: ").append(JVMCheck.fullVersion());
            sb.append(" suffers from critical bug ").append(this.bugUrl);
            sb.append(" which can cause data corruption.");
            sb.append(System.lineSeparator());
            sb.append("Please upgrade the JVM, see ").append(JVMCheck.JVM_RECOMMENDATIONS);
            sb.append(" for current recommendations.");
            if (this.workAround != null) {
                sb.append(System.lineSeparator());
                sb.append("If you absolutely cannot upgrade, please add ").append(this.workAround);
                sb.append(" to the JAVA_OPTS environment variable.");
                sb.append(System.lineSeparator());
                sb.append("Upgrading is preferred, this workaround will result in degraded performance.");
            }
            return sb.toString();
        }

        String getWarningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Workaround flag ").append(this.workAround);
            sb.append(" for bug ").append(this.bugUrl);
            sb.append(" found. ");
            sb.append(System.lineSeparator());
            sb.append("This will result in degraded performance!");
            sb.append(System.lineSeparator());
            sb.append("Upgrading is preferred, see ").append(JVMCheck.JVM_RECOMMENDATIONS);
            sb.append(" for current recommendations.");
            return sb.toString();
        }
    }
}

