/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRenderer
extends ReportRenderer<ComponentSpec, TextReportBuilder> {
    private final ReportRenderer<LanguageSourceSet, TextReportBuilder> sourceSetRenderer;
    private final ReportRenderer<BinarySpec, TextReportBuilder> binaryRenderer;

    public ComponentRenderer(ReportRenderer<LanguageSourceSet, TextReportBuilder> sourceSetRenderer, ReportRenderer<BinarySpec, TextReportBuilder> binaryRenderer) {
        this.sourceSetRenderer = sourceSetRenderer;
        this.binaryRenderer = binaryRenderer;
    }

    public void render(ComponentSpec component, TextReportBuilder builder) {
        builder.heading(StringUtils.capitalize((String)component.getDisplayName()));
        builder.getOutput().println();
        builder.collection("Source sets", CollectionUtils.sort((Iterable)component.getSources().values(), SourceSetRenderer.SORT_ORDER), this.sourceSetRenderer, "source sets");
        builder.getOutput().println();
        builder.collection("Binaries", CollectionUtils.sort((Iterable)component.getBinaries().values(), TypeAwareBinaryRenderer.SORT_ORDER), this.binaryRenderer, "binaries");
    }
}

