/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Scanner;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.process.internal.streams.ExecOutputHandleRunner;
import org.gradle.process.internal.streams.StreamsHandler;

public class DaemonOutputConsumer
implements StreamsHandler {
    private static final Logger LOGGER = Logging.getLogger(DaemonOutputConsumer.class);
    private final InputStream stdInput;
    private StringWriter output;
    private StoppableExecutor executor;
    private Runnable streamConsumer;
    DaemonStartupCommunication startupCommunication = new DaemonStartupCommunication();
    private String processOutput;
    private ExecOutputHandleRunner standardInputRunner;

    public DaemonOutputConsumer(InputStream stdInput) {
        this.stdInput = stdInput;
    }

    public void connectStreams(Process process, String processName, ExecutorFactory executorFactory) {
        if (process == null || processName == null) {
            throw new IllegalArgumentException("Cannot connect streams because provided process or its name is null");
        }
        this.standardInputRunner = new ExecOutputHandleRunner("write standard input into: " + processName, this.stdInput, process.getOutputStream());
        this.executor = executorFactory.create("Read output from: " + processName);
        final InputStream inputStream = process.getInputStream();
        this.streamConsumer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Scanner scanner = new Scanner(inputStream);
                PrintWriter printer = new PrintWriter(DaemonOutputConsumer.this.output);
                try {
                    while (scanner.hasNext()) {
                        String line = scanner.nextLine();
                        LOGGER.debug("daemon out: {}", line);
                        printer.println(line);
                        if (!DaemonOutputConsumer.this.startupCommunication.containsGreeting(line)) continue;
                        break;
                    }
                }
                finally {
                    scanner.close();
                }
            }
        };
    }

    public void start() {
        if (this.executor == null || this.streamConsumer == null) {
            throw new IllegalStateException("Cannot start consuming daemon output because streams have not been connected first.");
        }
        LOGGER.debug("Starting consuming the daemon process output.");
        this.output = new StringWriter();
        this.executor.execute(this.standardInputRunner);
        this.executor.execute(this.streamConsumer);
    }

    public String getProcessOutput() {
        if (this.processOutput == null) {
            throw new IllegalStateException("Unable to get process output as consuming has not finished yet.");
        }
        return this.processOutput;
    }

    public void stop() {
        if (this.executor == null || this.output == null) {
            throw new IllegalStateException("Unable to stop output consumer. Was it started?.");
        }
        try {
            this.standardInputRunner.closeInput();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.executor.stop();
        this.processOutput = this.output.toString();
    }
}

