/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.health.DaemonStats;
import org.gradle.launcher.daemon.server.health.DaemonStatus;
import org.gradle.launcher.daemon.server.health.HealthLogger;

class DaemonHealthTracker
implements DaemonCommandAction {
    private static final Logger LOG = Logging.getLogger(DaemonHealthTracker.class);
    private final DaemonStats stats;
    private final DaemonStatus status;
    private final HealthLogger logger;

    DaemonHealthTracker(DaemonStats stats, DaemonStatus status, HealthLogger logger) {
        this.stats = stats;
        this.status = status;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DaemonCommandExecution execution) {
        if (execution.isSingleUseDaemon()) {
            execution.proceed();
            return;
        }
        this.stats.buildStarted();
        this.logger.logHealth(this.stats, LOG);
        try {
            execution.proceed();
        }
        finally {
            this.stats.buildFinished();
        }
        if (this.status.isDaemonTired(this.stats)) {
            execution.getDaemonStateControl().requestStop();
        }
    }
}

