/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JvmBinarySpecInternal;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.language.base.internal.ProjectLayout;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;

public class JarBinaryRules
extends RuleSource {
    @Defaults
    void configureJarBinaries(ComponentSpec jvmLibrary, ProjectLayout projectLayout, final JavaToolChainRegistry toolChains) {
        final File buildDir = projectLayout.getBuildDir();
        jvmLibrary.getBinaries().withType(JvmBinarySpecInternal.class).beforeEach((Action)new Action<JvmBinarySpecInternal>(){

            public void execute(JvmBinarySpecInternal jvmBinary) {
                BinaryNamingScheme namingScheme = jvmBinary.getNamingScheme();
                jvmBinary.setClassesDir(namingScheme.getOutputDirectory(buildDir, "classes"));
                jvmBinary.setResourcesDir(namingScheme.getOutputDirectory(buildDir, "resources"));
            }
        });
        jvmLibrary.getBinaries().withType(JarBinarySpecInternal.class).beforeEach((Action)new Action<JarBinarySpecInternal>(){

            public void execute(JarBinarySpecInternal jarBinary) {
                String libraryName = jarBinary.getId().getLibraryName();
                File jarsDir = jarBinary.getNamingScheme().getOutputDirectory(buildDir, "jars");
                jarBinary.setJarFile(new File(jarsDir, String.format("%s.jar", libraryName)));
                jarBinary.setApiJarFile(new File(jarsDir, String.format("api/%s.jar", libraryName)));
                jarBinary.setToolChain((JavaToolChain)toolChains.getForPlatform(jarBinary.getTargetPlatform()));
            }
        });
    }
}

