/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.model.RuleSource;
import org.gradle.model.Rules;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.ExtractedRuleSource;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleDefinitionRuleExtractor
extends AbstractAnnotationDrivenModelRuleExtractor<Rules> {
    private static final ModelType<RuleSource> RULE_SOURCE_MODEL_TYPE = ModelType.of(RuleSource.class);

    @Override
    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        this.validateIsVoidMethod(ruleDefinition, context);
        if (ruleDefinition.getReferences().size() < 2) {
            context.add(ruleDefinition, "A method " + this.getDescription() + " must have at least two parameters");
            return null;
        }
        ModelType<?> ruleType = ruleDefinition.getReferences().get(0).getType();
        if (!RULE_SOURCE_MODEL_TYPE.isAssignableFrom(ruleType)) {
            context.add(ruleDefinition, "The first parameter of a method " + this.getDescription() + " must be a subtype of " + RuleSource.class.getName());
        }
        if (context.hasProblems()) {
            return null;
        }
        ModelType<RuleSource> ruleSourceType = ruleType.asSubtype(RULE_SOURCE_MODEL_TYPE);
        return new ExtractedRuleSourceDefinitionRule(ruleDefinition, ruleSourceType, context.getRuleExtractor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuleSourceApplicationAction
    implements MethodRuleAction {
        private final ModelReference<?> targetReference;
        private final ModelRuleDescriptor descriptor;
        private final List<ModelReference<?>> inputs;
        private final ModelType<? extends RuleSource> ruleSourceType;
        private final ModelRuleExtractor ruleExtractor;

        public RuleSourceApplicationAction(ModelReference<?> targetReference, ModelRuleDescriptor descriptor, List<ModelReference<?>> inputs, ModelType<? extends RuleSource> ruleSourceType, ModelRuleExtractor ruleExtractor) {
            this.targetReference = targetReference;
            this.descriptor = descriptor;
            this.inputs = inputs;
            this.ruleSourceType = ruleSourceType;
            this.ruleExtractor = ruleExtractor;
        }

        @Override
        public ModelReference<?> getSubject() {
            return this.targetReference;
        }

        @Override
        public List<? extends ModelReference<?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void execute(ModelRuleInvoker<?> invoker, MutableModelNode subjectNode, List<ModelView<?>> inputs) {
            ExtractedRuleSource<? extends RuleSource> ruleSource = this.ruleExtractor.extract(this.ruleSourceType.getConcreteClass());
            Object[] parameters = new Object[2 + inputs.size()];
            parameters[0] = ruleSource.getFactory().create();
            parameters[1] = subjectNode.asImmutable(this.targetReference.getType(), this.descriptor).getInstance();
            for (int i = 2; i < parameters.length; ++i) {
                parameters[i] = inputs.get(i).getInstance();
            }
            invoker.invoke(parameters);
            subjectNode.applyToSelf(ruleSource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedRuleSourceDefinitionRule
    implements ExtractedModelRule {
        private final MethodRuleDefinition<?, ?> ruleDefinition;
        private final ModelType<? extends RuleSource> ruleSourceType;
        private final ModelRuleExtractor ruleExtractor;

        public ExtractedRuleSourceDefinitionRule(MethodRuleDefinition<?, ?> ruleDefinition, ModelType<? extends RuleSource> ruleSourceType, ModelRuleExtractor ruleExtractor) {
            this.ruleDefinition = ruleDefinition;
            this.ruleSourceType = ruleSourceType;
            this.ruleExtractor = ruleExtractor;
        }

        @Override
        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            ModelReference<?> targetReference = this.ruleDefinition.getReferences().get(1);
            List<ModelReference<?>> inputs = this.ruleDefinition.getReferences().subList(2, this.ruleDefinition.getReferences().size());
            context.getRegistry().configure(ModelActionRole.Defaults, context.contextualize(this.ruleDefinition, new RuleSourceApplicationAction(targetReference, this.ruleDefinition.getDescriptor(), inputs, this.ruleSourceType, this.ruleExtractor)));
        }

        @Override
        public List<? extends Class<?>> getRuleDependencies() {
            return Collections.emptyList();
        }
    }
}

