/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.Named;
import org.gradle.nativeplatform.platform.Architecture;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualCppInstall
implements Named {
    private static final String COMPILER_FILENAME = "cl.exe";
    private static final String LINKER_FILENAME = "link.exe";
    private static final String ARCHIVER_FILENAME = "lib.exe";
    private final Map<Architecture, List<File>> paths;
    private final Map<Architecture, File> binaryPaths;
    private final Map<Architecture, File> libraryPaths;
    private final Map<Architecture, File> includePaths;
    private final Map<Architecture, String> assemblerFilenames;
    private final Map<Architecture, Map<String, String>> definitions;
    private final String name;
    private final VersionNumber version;

    public VisualCppInstall(String name, VersionNumber version, Map<Architecture, List<File>> paths, Map<Architecture, File> binaryPaths, Map<Architecture, File> libraryPaths, Map<Architecture, File> includePaths, Map<Architecture, String> assemblerFilenames, Map<Architecture, Map<String, String>> definitions) {
        this.paths = paths;
        this.name = name;
        this.version = version;
        this.binaryPaths = binaryPaths;
        this.libraryPaths = libraryPaths;
        this.includePaths = includePaths;
        this.assemblerFilenames = assemblerFilenames;
        this.definitions = definitions;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public boolean isSupportedPlatform(NativePlatformInternal targetPlatform) {
        return targetPlatform.getOperatingSystem().isWindows() && this.binaryPaths.containsKey(this.getPlatformArchitecture(targetPlatform));
    }

    public List<File> getPath(NativePlatformInternal targetPlatform) {
        return this.paths.get(this.getPlatformArchitecture(targetPlatform));
    }

    public File getCompiler(NativePlatformInternal targetPlatform) {
        return new File(this.binaryPaths.get(this.getPlatformArchitecture(targetPlatform)), COMPILER_FILENAME);
    }

    public File getLinker(NativePlatformInternal targetPlatform) {
        return new File(this.binaryPaths.get(this.getPlatformArchitecture(targetPlatform)), LINKER_FILENAME);
    }

    public File getArchiver(NativePlatformInternal targetPlatform) {
        return new File(this.binaryPaths.get(this.getPlatformArchitecture(targetPlatform)), ARCHIVER_FILENAME);
    }

    public File getAssembler(NativePlatformInternal targetPlatform) {
        Architecture architecture = this.getPlatformArchitecture(targetPlatform);
        return new File(this.binaryPaths.get(architecture), this.assemblerFilenames.get(architecture));
    }

    public File getBinaryPath(NativePlatformInternal targetPlatform) {
        return this.binaryPaths.get(this.getPlatformArchitecture(targetPlatform));
    }

    public File getLibraryPath(NativePlatformInternal targetPlatform) {
        return this.libraryPaths.get(this.getPlatformArchitecture(targetPlatform));
    }

    public Map<String, String> getDefinitions(NativePlatformInternal targetPlatform) {
        return this.definitions.get(this.getPlatformArchitecture(targetPlatform));
    }

    public File getIncludePath(NativePlatformInternal targetPlatform) {
        return this.includePaths.get(this.getPlatformArchitecture(targetPlatform));
    }

    private Architecture getPlatformArchitecture(NativePlatformInternal targetPlatform) {
        return targetPlatform.getArchitecture();
    }
}

