/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.play.internal.run.PlayRunSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlayRunSpec
implements PlayRunSpec,
Serializable {
    private final Iterable<File> classpath;
    private final Iterable<File> changingClasspath;
    private final File applicationJar;
    private final File assetsJar;
    private final Iterable<File> assetsDirs;
    private final File projectPath;
    private BaseForkOptions forkOptions;
    private int httpPort;

    public DefaultPlayRunSpec(Iterable<File> classpath, Iterable<File> changingClasspath, File applicationJar, File assetsJar, Iterable<File> assetsDirs, File projectPath, BaseForkOptions forkOptions, int httpPort) {
        this.classpath = Sets.newHashSet(classpath);
        this.changingClasspath = changingClasspath != null ? Sets.newHashSet(changingClasspath) : Collections.emptySet();
        this.applicationJar = applicationJar;
        this.assetsJar = assetsJar;
        this.assetsDirs = assetsDirs;
        this.projectPath = projectPath;
        this.forkOptions = forkOptions;
        this.httpPort = httpPort;
    }

    @Override
    public BaseForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Override
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    @Override
    public Iterable<File> getChangingClasspath() {
        return this.changingClasspath;
    }

    @Override
    public File getProjectPath() {
        return this.projectPath;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public File getApplicationJar() {
        return this.applicationJar;
    }

    @Override
    public File getAssetsJar() {
        return this.assetsJar;
    }

    @Override
    public Iterable<File> getAssetsDirs() {
        return this.assetsDirs;
    }
}

