/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.test.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.component.local.model.UsageKind;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.internal.DefaultJvmBinarySpec;
import org.gradle.jvm.internal.DependencyResolvingClasspath;
import org.gradle.jvm.internal.JvmBinarySpecInternal;
import org.gradle.jvm.internal.WithDependencies;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.test.JUnitTestSuiteSpec;
import org.gradle.jvm.test.JvmTestSuiteBinarySpec;
import org.gradle.jvm.test.internal.JUnitTestSuiteBinarySpecInternal;
import org.gradle.language.base.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.language.base.internal.resolve.LocalComponentResolveContext;
import org.gradle.model.ModelMap;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.Variant;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.BinaryTasksCollectionWrapper;
import org.gradle.platform.base.internal.DefaultLibraryBinaryDependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJUnitTestSuiteBinarySpec
extends DefaultJvmBinarySpec
implements JUnitTestSuiteBinarySpecInternal,
WithJvmAssembly,
WithDependencies {
    private String junitVersion;
    private Collection<DependencySpec> binaryLevelDependencies = Lists.newLinkedList();
    private JvmBinarySpec testedBinary;
    private final DefaultTasksCollection tasks = new DefaultTasksCollection(super.getTasks());
    private VariantsMetaData variantsMetaData;
    private ArtifactDependencyResolver artifactDependencyResolver;
    private List<ResolutionAwareRepository> remoteRepositories;

    @Override
    public JvmTestSuiteBinarySpec.JvmTestSuiteTasks getTasks() {
        return this.tasks;
    }

    @Override
    public JUnitTestSuiteSpec getTestSuite() {
        return (JUnitTestSuiteSpec)this.getComponentAs(JUnitTestSuiteSpec.class);
    }

    @Override
    public JvmBinarySpec getTestedBinary() {
        return this.testedBinary;
    }

    protected String getTypeName() {
        return "Test suite";
    }

    @Override
    @Variant
    public String getjUnitVersion() {
        return this.junitVersion;
    }

    @Override
    public void setjUnitVersion(String version) {
        this.junitVersion = version;
    }

    public void setDependencies(Collection<DependencySpec> dependencies) {
        this.binaryLevelDependencies = dependencies;
    }

    public Collection<DependencySpec> getDependencies() {
        return this.binaryLevelDependencies;
    }

    @Override
    public void setTestedBinary(JvmBinarySpec testedBinary) {
        this.testedBinary = testedBinary;
    }

    @Override
    public DependencyResolvingClasspath getRuntimeClasspath() {
        return new DependencyResolvingClasspath((BinarySpecInternal)this, this.getDisplayName(), this.artifactDependencyResolver, this.remoteRepositories, (ResolveContext)this.createResolveContext());
    }

    @Override
    public void setArtifactDependencyResolver(ArtifactDependencyResolver artifactDependencyResolver) {
        this.artifactDependencyResolver = artifactDependencyResolver;
    }

    @Override
    public void setRepositories(List<ResolutionAwareRepository> repositories) {
        this.remoteRepositories = repositories;
    }

    @Override
    public void setVariantsMetaData(VariantsMetaData variantsMetaData) {
        this.variantsMetaData = variantsMetaData;
    }

    private LocalComponentResolveContext createResolveContext() {
        DefaultLibraryBinaryIdentifier thisId = new DefaultLibraryBinaryIdentifier(this.getId().getProjectPath(), this.getId().getLibraryName() + "Test", this.getId().getVariant());
        return new LocalComponentResolveContext((LibraryBinaryIdentifier)thisId, this.variantsMetaData, this.runtimeDependencies(), UsageKind.RUNTIME, this.getDisplayName());
    }

    private List<DependencySpec> runtimeDependencies() {
        ArrayList dependencies = Lists.newArrayList(this.binaryLevelDependencies);
        dependencies.add(DefaultLibraryBinaryDependencySpec.of((LibraryBinaryIdentifier)this.getId()));
        if (this.testedBinary != null) {
            JvmBinarySpecInternal binary = (JvmBinarySpecInternal)this.testedBinary;
            LibraryBinaryIdentifier id = binary.getId();
            dependencies.add(DefaultLibraryBinaryDependencySpec.of((LibraryBinaryIdentifier)id));
        }
        this.addSourceSetSpecificDependencies(dependencies, (ModelMap<LanguageSourceSet>)this.getSources());
        this.addSourceSetSpecificDependencies(dependencies, (ModelMap<LanguageSourceSet>)this.getTestSuite().getSources());
        return dependencies;
    }

    private void addSourceSetSpecificDependencies(List<DependencySpec> dependencies, ModelMap<LanguageSourceSet> sources) {
        for (LanguageSourceSet sourceSet : sources) {
            if (!(sourceSet instanceof DependentSourceSet)) continue;
            dependencies.addAll(((DependentSourceSet)sourceSet).getDependencies().getDependencies());
        }
    }

    static class DefaultTasksCollection
    extends BinaryTasksCollectionWrapper
    implements JvmTestSuiteBinarySpec.JvmTestSuiteTasks {
        public DefaultTasksCollection(BinaryTasksCollection delegate) {
            super(delegate);
        }

        public Test getRun() {
            return (Test)this.findSingleTaskWithType(Test.class);
        }
    }
}

