/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.test.internal;

import com.google.common.base.Predicate;
import org.gradle.jvm.test.JUnitTestSuiteBinarySpec;
import org.gradle.jvm.test.JUnitTestSuiteSpec;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.DefaultModuleDependencySpec;

public class JUnitTestSuiteRules
extends RuleSource {
    public static void apply(ModelRegistry modelRegistry) {
        modelRegistry.getRoot().applyTo(NodePredicate.allDescendants((Predicate)ModelNodes.withType(JUnitTestSuiteSpec.class)), SpecRules.class);
        modelRegistry.getRoot().applyTo(NodePredicate.allDescendants((Predicate)ModelNodes.withType(JUnitTestSuiteBinarySpec.class)), BinaryRules.class);
    }

    static class BinaryRules
    extends RuleSource {
        BinaryRules() {
        }

        @Defaults
        void configureBinaryJUnitVersion(JUnitTestSuiteBinarySpec testSuiteBinary) {
            JUnitTestSuiteSpec testSuite = testSuiteBinary.getTestSuite();
            String jUnitVersion = testSuite.getjUnitVersion();
            testSuiteBinary.setjUnitVersion(jUnitVersion);
            testSuiteBinary.getDependencies().add(BinaryRules.junitDependencySpec(jUnitVersion));
        }

        private static DependencySpec junitDependencySpec(String jUnitVersion) {
            return new DefaultModuleDependencySpec("junit", "junit", jUnitVersion);
        }
    }

    static class SpecRules
    extends RuleSource {
        SpecRules() {
        }

        @Validate
        void validateJUnitVersion(JUnitTestSuiteSpec jUnitTestSuiteSpec) {
            if (jUnitTestSuiteSpec.getjUnitVersion() == null) {
                throw new InvalidModelException(String.format("Test suite '%s' doesn't declare JUnit version. Please specify it with `jUnitVersion '4.12'` for example.", jUnitTestSuiteSpec.getName()));
            }
        }
    }
}

