/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherEventListener;
import org.gradle.logging.StyledTextOutput;

public class ChangeReporter
implements FileWatcherEventListener {
    public static final int SHOW_INDIVIDUAL_CHANGES_LIMIT = 3;
    private final Map<File, FileWatcherEvent.Type> aggregatedEvents = Maps.newLinkedHashMap();
    private int moreChangesCount;

    private void logOutput(StyledTextOutput logger, String message, Object ... objects) {
        logger.formatln(message, objects);
    }

    public void onChange(FileWatcherEvent event) {
        if (event.getType() == FileWatcherEvent.Type.UNDEFINED) {
            return;
        }
        File file = event.getFile();
        FileWatcherEvent.Type existingType = this.aggregatedEvents.get(file);
        if (existingType == event.getType() || existingType == FileWatcherEvent.Type.CREATE && event.getType() == FileWatcherEvent.Type.MODIFY) {
            return;
        }
        if (existingType != null || this.aggregatedEvents.size() < 3) {
            this.aggregatedEvents.put(file, event.getType());
        } else if (event.getType() != FileWatcherEvent.Type.CREATE || event.getFile().isDirectory()) {
            ++this.moreChangesCount;
        }
    }

    public void reportChanges(StyledTextOutput logger) {
        for (Map.Entry<File, FileWatcherEvent.Type> entry : this.aggregatedEvents.entrySet()) {
            FileWatcherEvent.Type changeType = entry.getValue();
            File file = entry.getKey();
            this.showIndividualChange(logger, file, changeType);
        }
        if (this.moreChangesCount > 0) {
            this.logOutput(logger, "and some more changes", new Object[0]);
        }
    }

    private void showIndividualChange(StyledTextOutput logger, File file, FileWatcherEvent.Type changeType) {
        String changeDescription;
        switch (changeType) {
            case CREATE: {
                changeDescription = "new " + (file.isDirectory() ? "directory" : "file");
                break;
            }
            case DELETE: {
                changeDescription = "deleted";
                break;
            }
            default: {
                changeDescription = "modified";
            }
        }
        this.logOutput(logger, "%s: %s", changeDescription, file.getAbsolutePath());
    }
}

