/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetFactory;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageTypeModelRuleExtractor
extends TypeModelRuleExtractor<LanguageType, LanguageSourceSet, BaseLanguageSourceSet> {
    public LanguageTypeModelRuleExtractor(ModelSchemaStore schemaStore) {
        super("language", LanguageSourceSet.class, BaseLanguageSourceSet.class, LanguageTypeBuilder.class, schemaStore);
    }

    @Override
    protected <P extends LanguageSourceSet> ExtractedModelRule createExtractedRule(MethodRuleDefinition<?, ?> ruleDefinition, ModelType<P> type) {
        return new ExtractedLanguageTypeRule<P>(ruleDefinition, type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtractedLanguageTypeRule<PUBLICTYPE extends LanguageSourceSet>
    extends TypeModelRuleExtractor.ExtractedTypeRule<PUBLICTYPE, DefaultLanguageTypeBuilder<PUBLICTYPE>, LanguageSourceSetFactory> {
        public ExtractedLanguageTypeRule(MethodRuleDefinition<?, ?> ruleDefinition, ModelType<PUBLICTYPE> publicType) {
            super(LanguageTypeModelRuleExtractor.this, ruleDefinition, publicType);
        }

        @Override
        protected DefaultLanguageTypeBuilder<PUBLICTYPE> createBuilder(ModelSchema<PUBLICTYPE> schema) {
            return new DefaultLanguageTypeBuilder(schema);
        }

        @Override
        protected Class<LanguageSourceSetFactory> getRegistryType() {
            return LanguageSourceSetFactory.class;
        }

        @Override
        protected void register(LanguageSourceSetFactory factory, ModelSchema<PUBLICTYPE> schema, DefaultLanguageTypeBuilder<PUBLICTYPE> builder, ModelType<? extends BaseLanguageSourceSet> implModelType) {
            String languageName = builder.getLanguageName();
            if (!ModelType.of(LanguageSourceSet.class).equals((Object)this.publicType) && StringUtils.isEmpty((String)languageName)) {
                throw new InvalidModelException(String.format("Language type '%s' cannot be registered without a language name.", this.publicType));
            }
            factory.register(languageName, this.publicType, builder.getInternalViews(), implModelType, this.ruleDefinition.getDescriptor());
        }

        public List<? extends Class<?>> getRuleDependencies() {
            return ImmutableList.of(LanguageBasePlugin.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLanguageTypeBuilder<PUBLICTYPE extends LanguageSourceSet>
    extends AbstractTypeBuilder<PUBLICTYPE>
    implements LanguageTypeBuilder<PUBLICTYPE> {
        private String languageName;

        private DefaultLanguageTypeBuilder(ModelSchema<PUBLICTYPE> schema) {
            super(LanguageType.class, schema);
        }

        @Override
        public void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        public String getLanguageName() {
            return this.languageName;
        }
    }
}

