/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadKeywordRestArgumentNode
extends RubyNode {
    private final String[] excludedKeywords;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;

    public ReadKeywordRestArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String[] excludedKeywords) {
        super(context, sourceSection);
        this.excludedKeywords = excludedKeywords;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(context, sourceSection, minimum);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.lookupRestKeywordArgumentHash(frame);
    }

    private Object lookupRestKeywordArgumentHash(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        DynamicObject hash = (DynamicObject)this.readUserKeywordsHashNode.execute(frame);
        if (hash == null) {
            return Layouts.HASH.createHash(this.getContext().getCoreLibrary().getHashFactory(), null, 0, null, null, null, null, false);
        }
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>();
        block0: for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(hash)) {
            if (!RubyGuards.isRubySymbol(keyValue.getKey())) continue;
            for (String excludedKeyword : this.excludedKeywords) {
                if (excludedKeyword.equals(keyValue.getKey().toString())) continue block0;
            }
            entries.add(keyValue);
        }
        return BucketsStrategy.create(this.getContext(), entries, Layouts.HASH.getCompareByIdentity(hash));
    }
}

