/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import org.apache.lucene.bkdtree3d.Geo3DDocValuesFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;

public final class Geo3DPointField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public Geo3DPointField(String name, PlanetModel planetModel, double lat, double lon) {
        super(name, TYPE);
        GeoPoint point = new GeoPoint(planetModel, lat, lon);
        this.fillFieldsData(planetModel.getMaximumMagnitude(), point.x, point.y, point.z);
    }

    public Geo3DPointField(String name, PlanetModel planetModel, double x, double y, double z) {
        super(name, TYPE);
        this.fillFieldsData(planetModel.getMaximumMagnitude(), x, y, z);
    }

    private void fillFieldsData(double planetMax, double x, double y, double z) {
        byte[] bytes = new byte[12];
        Geo3DDocValuesFormat.writeInt(Geo3DDocValuesFormat.encodeValue(planetMax, x), bytes, 0);
        Geo3DDocValuesFormat.writeInt(Geo3DDocValuesFormat.encodeValue(planetMax, y), bytes, 4);
        Geo3DDocValuesFormat.writeInt(Geo3DDocValuesFormat.encodeValue(planetMax, z), bytes, 8);
        this.fieldsData = new BytesRef(bytes);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.BINARY);
        TYPE.freeze();
    }
}

