/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanWeight;

public abstract class Spans
extends Scorer {
    public static final int NO_MORE_POSITIONS = Integer.MAX_VALUE;
    protected final Similarity.SimScorer docScorer;
    protected float freq;
    protected int numMatches;
    private int lastScoredDoc = -1;

    protected Spans(SpanWeight weight, Similarity.SimScorer docScorer) {
        super(weight);
        this.docScorer = docScorer;
    }

    public abstract int nextStartPosition() throws IOException;

    public abstract int startPosition();

    public abstract int endPosition();

    public abstract int width();

    public abstract void collect(SpanCollector var1) throws IOException;

    public abstract float positionsCost();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = this.getClass();
        sb.append(clazz.isAnonymousClass() ? clazz.getName() : clazz.getSimpleName());
        sb.append("(doc=").append(this.docID());
        sb.append(",start=").append(this.startPosition());
        sb.append(",end=").append(this.endPosition());
        sb.append(")");
        return sb.toString();
    }

    private void ensureFreq() throws IOException {
        int currentDoc = this.docID();
        if (this.lastScoredDoc != currentDoc) {
            this.setFreqCurrentDoc();
            this.lastScoredDoc = currentDoc;
        }
    }

    protected final void setFreqCurrentDoc() throws IOException {
        this.freq = 0.0f;
        this.numMatches = 0;
        this.doStartCurrentDoc();
        assert (this.startPosition() == -1) : "incorrect initial start position, " + this.toString();
        assert (this.endPosition() == -1) : "incorrect initial end position, " + this.toString();
        int prevStartPos = -1;
        int prevEndPos = -1;
        int startPos = this.nextStartPosition();
        assert (startPos != Integer.MAX_VALUE) : "initial startPos NO_MORE_POSITIONS, " + this.toString();
        do {
            assert (startPos >= prevStartPos);
            int endPos = this.endPosition();
            assert (endPos != Integer.MAX_VALUE);
            assert (startPos != prevStartPos || endPos >= prevEndPos) : "decreased endPos=" + endPos;
            ++this.numMatches;
            if (this.docScorer == null) {
                this.freq = 1.0f;
                return;
            }
            this.freq += this.docScorer.computeSlopFactor(this.width());
            this.doCurrentSpans();
            prevStartPos = startPos;
            prevEndPos = endPos;
        } while ((startPos = this.nextStartPosition()) != Integer.MAX_VALUE);
        assert (this.startPosition() == Integer.MAX_VALUE) : "incorrect final start position, " + this.toString();
        assert (this.endPosition() == Integer.MAX_VALUE) : "incorrect final end position, " + this.toString();
    }

    protected void doStartCurrentDoc() throws IOException {
    }

    protected void doCurrentSpans() throws IOException {
    }

    protected float scoreCurrentDoc() throws IOException {
        assert (this.docScorer != null) : this.getClass() + " has a null docScorer!";
        return this.docScorer.score(this.docID(), this.freq);
    }

    @Override
    public final float score() throws IOException {
        this.ensureFreq();
        return this.scoreCurrentDoc();
    }

    @Override
    public final int freq() throws IOException {
        this.ensureFreq();
        return this.numMatches;
    }

    public final float sloppyFreq() throws IOException {
        this.ensureFreq();
        return this.freq;
    }
}

